/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.iptc;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.GenericImageMetadata;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceFile;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegImageParser;
import org.apache.commons.imaging.formats.jpeg.JpegImagingParameters;
import org.apache.commons.imaging.formats.jpeg.JpegPhotoshopMetadata;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcBlock;
import org.apache.commons.imaging.formats.jpeg.iptc.PhotoshopApp13Data;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IptcParserTest {
    @Test
    public void testSkipBlockTypes() throws ImageReadException, IOException {
        String location = IptcParserTest.class.getResource("/images/jpeg/photoshop/IMAGING-246/FallHarvestKitKat_07610.jpg").getFile();
        File imageFile = new File(location);
        JpegImageMetadata metadata = (JpegImageMetadata)new JpegImageParser().getMetadata((ByteSource)new ByteSourceFile(imageFile), new JpegImagingParameters());
        JpegPhotoshopMetadata photoshopMetadata = metadata.getPhotoshop();
        PhotoshopApp13Data photoshopApp13Data = photoshopMetadata.photoshopApp13Data;
        List blocks = photoshopApp13Data.getRawBlocks();
        Assertions.assertEquals((int)2, (int)blocks.size());
        for (IptcBlock block : blocks) {
            byte[] data;
            if (block.getBlockType() == 1028) {
                data = block.getBlockData();
                Assertions.assertTrue((data.length > 0 ? 1 : 0) != 0);
                continue;
            }
            if (block.getBlockType() == 1061) {
                data = block.getBlockData();
                Assertions.assertTrue((data.length > 0 ? 1 : 0) != 0);
                continue;
            }
            Assertions.fail((String)("Unexpected block type found: " + block.getBlockType()));
        }
    }

    @Test
    public void testEncodingSupport() throws IOException, ImageReadException {
        File file = new File(IptcParserTest.class.getResource("/images/jpeg/iptc/IMAGING-168/111083453-c07f1880-851e-11eb-8b61-2757f7d934bf.jpg").getFile());
        JpegImageParser parser = new JpegImageParser();
        JpegImageMetadata metadata = (JpegImageMetadata)parser.getMetadata(file);
        JpegPhotoshopMetadata photoshopMetadata = metadata.getPhotoshop();
        List items = photoshopMetadata.getItems();
        GenericImageMetadata.GenericImageMetadataItem thanksInMandarin = (GenericImageMetadata.GenericImageMetadataItem)items.get(3);
        Assertions.assertArrayEquals((byte[])"\u8c22\u8c22".getBytes(StandardCharsets.UTF_8), (byte[])thanksInMandarin.getText().getBytes(StandardCharsets.UTF_8));
    }
}

