/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.iptc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceFile;
import org.apache.commons.imaging.formats.jpeg.JpegImageParser;
import org.apache.commons.imaging.formats.jpeg.JpegImagingParameters;
import org.apache.commons.imaging.formats.jpeg.JpegPhotoshopMetadata;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcBaseTest;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcRecord;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcType;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcTypes;
import org.apache.commons.imaging.formats.jpeg.iptc.JpegIptcRewriter;
import org.apache.commons.imaging.formats.jpeg.iptc.PhotoshopApp13Data;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class IptcUpdateTest
extends IptcBaseTest {
    public static Stream<File> data() throws Exception {
        return IptcUpdateTest.getImagesWithIptcData().stream();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testRemove(File imageFile) throws Exception {
        ByteSourceFile byteSource = new ByteSourceFile(imageFile);
        JpegImagingParameters params = new JpegImagingParameters();
        JpegPhotoshopMetadata metadata = new JpegImageParser().getPhotoshopMetadata((ByteSource)byteSource, params);
        Assertions.assertNotNull((Object)metadata);
        File noIptcFile = this.removeIptc((ByteSource)byteSource, imageFile);
        JpegPhotoshopMetadata outMetadata = new JpegImageParser().getPhotoshopMetadata((ByteSource)new ByteSourceFile(noIptcFile), params);
        Assertions.assertTrue((outMetadata == null || outMetadata.getItems().isEmpty() ? 1 : 0) != 0);
    }

    public File removeIptc(ByteSource byteSource, File imageFile) throws Exception {
        File noIptcFile = File.createTempFile(imageFile.getName() + ".iptc.remove.", ".jpg");
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(noIptcFile));){
            new JpegIptcRewriter().removeIPTC(byteSource, (OutputStream)os);
        }
        return noIptcFile;
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testInsert(File imageFile) throws Exception {
        ByteSourceFile byteSource = new ByteSourceFile(imageFile);
        JpegImagingParameters params = new JpegImagingParameters();
        JpegPhotoshopMetadata metadata = new JpegImageParser().getPhotoshopMetadata((ByteSource)byteSource, params);
        Assertions.assertNotNull((Object)metadata);
        File noIptcFile = this.removeIptc((ByteSource)byteSource, imageFile);
        ArrayList newBlocks = new ArrayList();
        ArrayList<IptcRecord> newRecords = new ArrayList<IptcRecord>();
        newRecords.add(new IptcRecord((IptcType)IptcTypes.CITY, "Albany, NY"));
        newRecords.add(new IptcRecord((IptcType)IptcTypes.CREDIT, "William Sorensen"));
        PhotoshopApp13Data newData = new PhotoshopApp13Data(newRecords, newBlocks);
        File updated = File.createTempFile(imageFile.getName() + ".iptc.insert.", ".jpg");
        try (FileOutputStream fos = new FileOutputStream(updated);
             BufferedOutputStream os = new BufferedOutputStream(fos);){
            new JpegIptcRewriter().writeIPTC((ByteSource)new ByteSourceFile(noIptcFile), (OutputStream)os, newData);
        }
        ByteSourceFile updateByteSource = new ByteSourceFile(updated);
        JpegPhotoshopMetadata outMetadata = new JpegImageParser().getPhotoshopMetadata((ByteSource)updateByteSource, params);
        Assertions.assertNotNull((Object)outMetadata);
        Assertions.assertEquals((int)2, (int)outMetadata.getItems().size());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testUpdate(File imageFile) throws Exception {
        ByteSourceFile byteSource = new ByteSourceFile(imageFile);
        JpegImagingParameters params = new JpegImagingParameters();
        JpegPhotoshopMetadata metadata = new JpegImageParser().getPhotoshopMetadata((ByteSource)byteSource, params);
        Assertions.assertNotNull((Object)metadata);
        List newBlocks = metadata.photoshopApp13Data.getNonIptcBlocks();
        ArrayList<IptcRecord> newRecords = new ArrayList<IptcRecord>();
        newRecords.add(new IptcRecord((IptcType)IptcTypes.CITY, "Albany, NY"));
        newRecords.add(new IptcRecord((IptcType)IptcTypes.CREDIT, "William Sorensen"));
        PhotoshopApp13Data newData = new PhotoshopApp13Data(newRecords, newBlocks);
        File updated = this.writeIptc((ByteSource)byteSource, newData, imageFile);
        ByteSourceFile updateByteSource = new ByteSourceFile(updated);
        JpegPhotoshopMetadata outMetadata = new JpegImageParser().getPhotoshopMetadata((ByteSource)updateByteSource, params);
        Assertions.assertNotNull((Object)outMetadata);
        Assertions.assertEquals((int)2, (int)outMetadata.getItems().size());
    }

    public File writeIptc(ByteSource byteSource, PhotoshopApp13Data newData, File imageFile) throws IOException, ImageReadException, ImageWriteException {
        File updated = File.createTempFile(imageFile.getName() + ".iptc.update.", ".jpg");
        try (FileOutputStream fos = new FileOutputStream(updated);
             BufferedOutputStream os = new BufferedOutputStream(fos);){
            new JpegIptcRewriter().writeIPTC(byteSource, (OutputStream)os, newData);
        }
        return updated;
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testNoChangeUpdate(File imageFile) throws Exception {
        ByteSourceFile byteSource = new ByteSourceFile(imageFile);
        JpegImagingParameters params = new JpegImagingParameters();
        JpegPhotoshopMetadata metadata = new JpegImageParser().getPhotoshopMetadata((ByteSource)byteSource, params);
        Assertions.assertNotNull((Object)metadata);
        List newBlocks = metadata.photoshopApp13Data.getNonIptcBlocks();
        List oldRecords = metadata.photoshopApp13Data.getRecords();
        ArrayList<IptcRecord> newRecords = new ArrayList<IptcRecord>();
        for (IptcRecord record : oldRecords) {
            if (record.iptcType == IptcTypes.CITY || record.iptcType == IptcTypes.CREDIT) continue;
            newRecords.add(record);
        }
        newRecords.add(new IptcRecord((IptcType)IptcTypes.CITY, "Albany, NY"));
        newRecords.add(new IptcRecord((IptcType)IptcTypes.CREDIT, "William Sorensen"));
        PhotoshopApp13Data newData = new PhotoshopApp13Data(newRecords, newBlocks);
        File updated = this.writeIptc((ByteSource)byteSource, newData, imageFile);
        ByteSourceFile updateByteSource = new ByteSourceFile(updated);
        JpegPhotoshopMetadata outMetadata = new JpegImageParser().getPhotoshopMetadata((ByteSource)updateByteSource, params);
        Assertions.assertNotNull((Object)outMetadata);
        Assertions.assertEquals((int)outMetadata.getItems().size(), (int)newRecords.size());
    }
}

