/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.xmp;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImagingTest;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceFile;
import org.apache.commons.imaging.formats.jpeg.JpegImageParser;

public abstract class JpegXmpBaseTest
extends ImagingTest {
    private static final ImagingTest.ImageFilter HAS_JPEG_XMP_IMAGE_FILTER = JpegXmpBaseTest::hasJpegXmpData;

    protected static boolean hasJpegXmpData(File file) {
        if (!file.getName().toLowerCase().endsWith(".jpg")) {
            return false;
        }
        try {
            ByteSourceFile byteSource = new ByteSourceFile(file);
            return new JpegImageParser().hasXmpSegment((ByteSource)byteSource);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected File getImageWithXmpData() throws IOException, ImageReadException {
        return this.getTestImage(HAS_JPEG_XMP_IMAGE_FILTER);
    }

    protected static List<File> getImagesWithXmpData() throws IOException, ImageReadException {
        return JpegXmpBaseTest.getTestImages(HAS_JPEG_XMP_IMAGE_FILTER);
    }

    protected List<File> getImagesWithXmpData(int max) throws IOException, ImageReadException {
        return JpegXmpBaseTest.getTestImages(HAS_JPEG_XMP_IMAGE_FILTER, max);
    }
}

