/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.xmp;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.stream.Stream;
import org.apache.commons.imaging.common.XmpImagingParameters;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceFile;
import org.apache.commons.imaging.formats.jpeg.JpegImageParser;
import org.apache.commons.imaging.formats.jpeg.JpegImagingParameters;
import org.apache.commons.imaging.formats.jpeg.xmp.JpegXmpBaseTest;
import org.apache.commons.imaging.formats.jpeg.xmp.JpegXmpRewriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class JpegXmpRewriteTest
extends JpegXmpBaseTest {
    public static Stream<File> data() throws Exception {
        return JpegXmpRewriteTest.getImagesWithXmpData().stream();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testRemoveInsertUpdate(File imageFile) throws Exception {
        BufferedOutputStream os;
        ByteSourceFile byteSource = new ByteSourceFile(imageFile);
        JpegImagingParameters params = new JpegImagingParameters();
        String xmpXml = new JpegImageParser().getXmpXml((ByteSource)byteSource, (XmpImagingParameters)params);
        Assertions.assertNotNull((Object)xmpXml);
        File noXmpFile = File.createTempFile(imageFile.getName() + ".", ".jpg");
        try (FileOutputStream fos = new FileOutputStream(noXmpFile);
             BufferedOutputStream os2 = new BufferedOutputStream(fos);){
            new JpegXmpRewriter().removeXmpXml((ByteSource)byteSource, (OutputStream)os2);
        }
        String outXmp = new JpegImageParser().getXmpXml((ByteSource)new ByteSourceFile(noXmpFile), (XmpImagingParameters)params);
        Assertions.assertNull((Object)outXmp);
        String newXmpXml = "test";
        File updated = File.createTempFile(imageFile.getName() + ".", ".jpg");
        try (FileOutputStream fos = new FileOutputStream(updated);){
            os = new BufferedOutputStream(fos);
            try {
                new JpegXmpRewriter().updateXmpXml((ByteSource)byteSource, (OutputStream)os, "test");
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        String outXmp2 = new JpegImageParser().getXmpXml((ByteSource)new ByteSourceFile(updated), (XmpImagingParameters)params);
        Assertions.assertNotNull((Object)outXmp2);
        Assertions.assertEquals((Object)outXmp2, (Object)"test");
        newXmpXml = "test";
        updated = File.createTempFile(imageFile.getName() + ".", ".jpg");
        fos = new FileOutputStream(updated);
        try {
            os = new BufferedOutputStream(fos);
            try {
                new JpegXmpRewriter().updateXmpXml((ByteSource)new ByteSourceFile(noXmpFile), (OutputStream)os, "test");
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        finally {
            fos.close();
        }
        outXmp2 = new JpegImageParser().getXmpXml((ByteSource)new ByteSourceFile(updated), (XmpImagingParameters)params);
        Assertions.assertNotNull((Object)outXmp2);
        Assertions.assertEquals((Object)outXmp2, (Object)"test");
    }
}

