/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.awt.image.BufferedImage;
import java.io.File;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.formats.png.PngBaseTest;
import org.apache.commons.imaging.internal.Debug;
import org.apache.commons.io.FilenameUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PngMultipleRoundtripTest
extends PngBaseTest {
    @Test
    public void test() throws Exception {
        File[] files;
        String imagesFolderPath = FilenameUtils.separatorsToSystem((String)"src\\test\\data\\images\\png\\3");
        File imagesFolder = new File(imagesFolderPath);
        Assertions.assertTrue((imagesFolder.exists() && imagesFolder.isDirectory() ? 1 : 0) != 0);
        for (File file : files = imagesFolder.listFiles()) {
            File imageFile = file;
            if (!imageFile.isFile() || !imageFile.getName().toLowerCase().endsWith(".png")) continue;
            Debug.debug();
            Debug.debug((String)"imageFile", (Object)imageFile);
            File lastFile = imageFile;
            for (int j = 0; j < 10; ++j) {
                BufferedImage image = Imaging.getBufferedImage((File)lastFile);
                Assertions.assertNotNull((Object)image);
                File tempFile = File.createTempFile(imageFile.getName() + "." + j + ".", ".png");
                Debug.debug((String)"tempFile", (Object)tempFile);
                Imaging.writeImage((BufferedImage)image, (File)tempFile, (ImageFormat)ImageFormats.PNG);
                lastFile = tempFile;
            }
        }
    }
}

