/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceFile;
import org.apache.commons.imaging.formats.png.PngBaseTest;
import org.apache.commons.imaging.formats.png.PngImageParser;
import org.apache.commons.imaging.formats.png.PngImagingParameters;
import org.apache.commons.imaging.internal.Debug;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PngReadTest
extends PngBaseTest {
    @Test
    public void test() throws Exception {
        Debug.debug((String)"start");
        List<File> images = this.getPngImages();
        for (File imageFile : images) {
            Debug.debug((String)"imageFile", (Object)imageFile);
            if (this.isInvalidPNGTestFile(imageFile)) {
                Assertions.assertThrows(Exception.class, () -> Imaging.getMetadata((File)imageFile), (String)"Image read should have failed.");
                Assertions.assertThrows(Exception.class, () -> Imaging.getImageInfo((File)imageFile), (String)"Image read should have failed.");
                Assertions.assertThrows(Exception.class, () -> Imaging.getBufferedImage((File)imageFile), (String)"Image read should have failed.");
                continue;
            }
            ImageMetadata metadata = Imaging.getMetadata((File)imageFile);
            Assertions.assertFalse((boolean)(metadata instanceof File));
            ImageInfo imageInfo = Imaging.getImageInfo((File)imageFile);
            Assertions.assertNotNull((Object)imageInfo);
            Debug.debug((String)"ICC profile", (Object)Imaging.getICCProfile((File)imageFile));
            BufferedImage image = Imaging.getBufferedImage((File)imageFile);
            Assertions.assertNotNull((Object)image);
        }
    }

    @Test
    public void testUncaughtExceptionOssFuzz33691() throws IOException {
        String input = "/images/png/oss-fuzz-33691/clusterfuzz-testcase-minimized-ImagingPngFuzzer-6177282101215232";
        String file = PngReadTest.class.getResource("/images/png/oss-fuzz-33691/clusterfuzz-testcase-minimized-ImagingPngFuzzer-6177282101215232").getFile();
        PngImageParser parser = new PngImageParser();
        Assertions.assertThrows(ImageReadException.class, () -> parser.getBufferedImage((ByteSource)new ByteSourceFile(new File(file)), new PngImagingParameters()));
    }

    @Test
    public void testUncaughtExceptionOssFuzz37607() throws IOException {
        String input = "/images/png/IMAGING-317/clusterfuzz-testcase-minimized-ImagingPngFuzzer-6242400830357504";
        String file = PngReadTest.class.getResource("/images/png/IMAGING-317/clusterfuzz-testcase-minimized-ImagingPngFuzzer-6242400830357504").getFile();
        PngImageParser parser = new PngImageParser();
        Assertions.assertThrows(ImageReadException.class, () -> parser.getBufferedImage((ByteSource)new ByteSourceFile(new File(file)), new PngImagingParameters()));
    }
}

