/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.formats.png.PngBaseTest;
import org.apache.commons.imaging.formats.png.PngImageInfo;
import org.apache.commons.imaging.formats.png.PngImageParser;
import org.apache.commons.imaging.formats.png.PngImagingParameters;
import org.apache.commons.imaging.formats.png.PngText;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PngTextTest
extends PngBaseTest {
    @Test
    public void test() throws Exception {
        byte[] bytes;
        boolean width = true;
        boolean height = true;
        BufferedImage srcImage = new BufferedImage(1, 1, 2);
        srcImage.setRGB(0, 0, Color.red.getRGB());
        PngImagingParameters writeParams = new PngImagingParameters();
        ArrayList<Object> writeTexts = new ArrayList<Object>();
        String keyword = "a";
        String text = "b";
        writeTexts.add(new PngText.Text("a", "b"));
        keyword = "c";
        text = "d";
        writeTexts.add(new PngText.Ztxt("c", "d"));
        keyword = "e";
        text = "f";
        String languageTag = "g";
        String translatedKeyword = "h";
        writeTexts.add(new PngText.Itxt("e", "f", "g", "h"));
        writeParams.setTextChunks(writeTexts);
        PngImageParser pngImageParser = new PngImageParser();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            pngImageParser.writeImage(srcImage, (OutputStream)baos, writeParams);
            bytes = baos.toByteArray();
        }
        File tempFile = File.createTempFile("temp", ".png");
        FileUtils.writeByteArrayToFile((File)tempFile, (byte[])bytes);
        PngImageInfo imageInfo = (PngImageInfo)Imaging.getImageInfo((byte[])bytes);
        Assertions.assertNotNull((Object)imageInfo);
        List readTexts = imageInfo.getTextChunks();
        Assertions.assertEquals((int)readTexts.size(), (int)3);
        for (PngText text2 : readTexts) {
            if (text2.keyword.equals("a")) {
                Assertions.assertEquals((Object)text2.text, (Object)"b");
                continue;
            }
            if (text2.keyword.equals("c")) {
                Assertions.assertEquals((Object)text2.text, (Object)"d");
                continue;
            }
            if (text2.keyword.equals("e")) {
                Assertions.assertEquals((Object)text2.text, (Object)"f");
                continue;
            }
            Assertions.fail((String)"unknown text chunk.");
        }
    }
}

