/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.io.File;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImagingParameters;
import org.apache.commons.imaging.common.BufferedImageFactory;
import org.apache.commons.imaging.examples.ImageReadExample;
import org.apache.commons.imaging.formats.jpeg.JpegWithInvalidDhtSegmentTest;
import org.apache.commons.imaging.formats.png.PngImageParser;
import org.apache.commons.imaging.formats.png.PngImagingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PngWithInvalidPngChunkSizeTest {
    @Test
    public void testPngWithInvalidPngChunkSize() {
        File imageFile = new File(JpegWithInvalidDhtSegmentTest.class.getResource("/IMAGING-211/testfile_2.png").getFile());
        PngImagingParameters params = new PngImagingParameters();
        params.setBufferedImageFactory((BufferedImageFactory)new ImageReadExample.ManagedImageBufferedImageFactory());
        PngImageParser jpegImageParser = new PngImageParser();
        Assertions.assertThrows(ImageReadException.class, () -> jpegImageParser.getBufferedImage(imageFile, (ImagingParameters)params));
    }

    @Test
    public void testPngWithInvalidNegativePngChunkSize() {
        File imageFile = new File(JpegWithInvalidDhtSegmentTest.class.getResource("/IMAGING-210/testfile.png").getFile());
        PngImagingParameters params = new PngImagingParameters();
        params.setBufferedImageFactory((BufferedImageFactory)new ImageReadExample.ManagedImageBufferedImageFactory());
        PngImageParser jpegImageParser = new PngImageParser();
        Assertions.assertThrows(ImageReadException.class, () -> jpegImageParser.getBufferedImage(imageFile, (ImagingParameters)params));
    }
}

