/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.imaging.ImagingParameters;
import org.apache.commons.imaging.formats.png.PngBaseTest;
import org.apache.commons.imaging.formats.png.PngImageParser;
import org.apache.commons.imaging.formats.png.PngImagingParameters;
import org.apache.commons.imaging.internal.Debug;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PngWriteForceTrueColorText
extends PngBaseTest {
    @Test
    public void test() throws Exception {
        PngImageParser pngImageParser = new PngImageParser();
        List<File> images = this.getPngImages();
        for (File imageFile : images) {
            try {
                if (this.isInvalidPNGTestFile(imageFile)) continue;
                Debug.debug((String)"imageFile", (Object)imageFile);
                BufferedImage image = pngImageParser.getBufferedImage(imageFile, (ImagingParameters)new PngImagingParameters());
                Assertions.assertNotNull((Object)image);
                File outFile = File.createTempFile(imageFile.getName() + ".", ".gif");
                PngImagingParameters params = new PngImagingParameters();
                params.setForceTrueColor(Boolean.TRUE.booleanValue());
                try (FileOutputStream fos = new FileOutputStream(outFile);){
                    pngImageParser.writeImage(image, (OutputStream)fos, params);
                }
                BufferedImage image2 = pngImageParser.getBufferedImage(outFile, (ImagingParameters)new PngImagingParameters());
                Assertions.assertNotNull((Object)image2);
            }
            catch (Exception e) {
                Debug.debug((String)"imageFile", (Object)imageFile);
                throw e;
            }
        }
        Debug.debug((String)"complete.");
    }
}

