/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.formats.png.PngImageParser;
import org.apache.commons.imaging.formats.png.PngImagingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PngWritePredictorTest {
    @BeforeAll
    public static void setUpClass() {
    }

    @BeforeEach
    public void setUp() {
    }

    private int[] populateARGB() {
        int i;
        int[] argb = new int[65536];
        for (i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                int red = i;
                int green = 255 - i;
                int blue = j;
                argb[i * 256 + j] = ((0xFF00 | red) << 8 | green) << 8 | blue;
            }
        }
        for (i = 0; i < 256; ++i) {
            argb[i * 256 + i] = -16777216;
            if (i >= 255) continue;
            argb[i * 256 + i + 1] = -1;
        }
        return argb;
    }

    @Test
    void testWriteWithPredictor() {
        BufferedOutputStream bos;
        int[] argb = this.populateARGB();
        BufferedImage bImage = new BufferedImage(256, 256, 1);
        bImage.setRGB(0, 0, 256, 256, argb, 0, 256);
        File tempFile = null;
        try {
            tempFile = File.createTempFile("PngWritePredictorRGB", ".png");
        }
        catch (IOException ioex) {
            Assertions.fail((String)("Failed to create temporary file, " + ioex.getMessage()));
        }
        PngImagingParameters params = new PngImagingParameters();
        params.setPredictorEnabled(true);
        PngImageParser parser = new PngImageParser();
        try (FileOutputStream fos = new FileOutputStream(tempFile);){
            bos = new BufferedOutputStream(fos);
            try {
                parser.writeImage(bImage, (OutputStream)bos, params);
                bos.flush();
            }
            finally {
                bos.close();
            }
        }
        catch (IOException | ImageWriteException ex) {
            Assertions.fail((String)("Failed writing RGB with exception " + ex.getMessage()));
        }
        try {
            int[] brgb = new int[65536];
            bImage = ImageIO.read(tempFile);
            bImage.getRGB(0, 0, 256, 256, brgb, 0, 256);
            Assertions.assertArrayEquals((int[])argb, (int[])brgb, (String)"Round trip for RGB failed");
        }
        catch (IOException ex) {
            Assertions.fail((String)("Failed reading RGB with exception " + ex.getMessage()));
        }
        for (int i = 0; i < 256; ++i) {
            int n = i * 256 + i;
            argb[n] = argb[n] & 0x88FFFFFF;
        }
        bImage = new BufferedImage(256, 256, 2);
        bImage.setRGB(0, 0, 256, 256, argb, 0, 256);
        try (FileOutputStream fos = new FileOutputStream(tempFile);){
            bos = new BufferedOutputStream(fos);
            try {
                parser.writeImage(bImage, (OutputStream)bos, params);
                bos.flush();
            }
            finally {
                bos.close();
            }
        }
        catch (IOException | ImageWriteException ex) {
            Assertions.fail((String)("Failed writing ARGB with exception " + ex.getMessage()));
        }
        try {
            int[] brgb = new int[65536];
            bImage = ImageIO.read(tempFile);
            bImage.getRGB(0, 0, 256, 256, brgb, 0, 256);
            Assertions.assertArrayEquals((int[])argb, (int[])brgb, (String)"Round trip for ARGB failed");
        }
        catch (IOException ex) {
            Assertions.fail((String)("Failed reading ARGB with exception " + ex.getMessage()));
        }
    }
}

