/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png.chunks;

import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.formats.png.chunks.PngChunkScal;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PngChunkScalTest {
    private static final double delta = 0.001;
    private static final int chunkType = 1933787468;

    @Test
    public void testConstructMeters() throws ImageReadException {
        PngChunkScal pngChunkScal = new PngChunkScal(10, 1933787468, 0, new byte[]{1, 48, 46, 48, 49, 0, 48, 46, 48, 50});
        Assertions.assertEquals((int)pngChunkScal.unitSpecifier, (int)1);
        Assertions.assertEquals((double)pngChunkScal.unitsPerPixelXAxis, (double)0.01, (double)0.001);
        Assertions.assertEquals((double)pngChunkScal.unitsPerPixelYAxis, (double)0.02, (double)0.001);
    }

    @Test
    public void testConstructRadians() throws ImageReadException {
        PngChunkScal pngChunkScal = new PngChunkScal(10, 1933787468, 0, new byte[]{2, 48, 46, 48, 49, 0, 48, 46, 48, 50});
        Assertions.assertEquals((int)pngChunkScal.unitSpecifier, (int)2);
        Assertions.assertEquals((double)pngChunkScal.unitsPerPixelXAxis, (double)0.01, (double)0.001);
        Assertions.assertEquals((double)pngChunkScal.unitsPerPixelYAxis, (double)0.02, (double)0.001);
    }

    @Test
    public void testConstruct_InvalidUnitSpecifier() {
        Assertions.assertThrows(ImageReadException.class, () -> new PngChunkScal(10, 1933787468, 0, new byte[]{3, 48, 46, 48, 49, 0, 48, 46, 48, 50}));
    }

    @Test
    public void testConstruct_MissingSeparator() {
        Assertions.assertThrows(ImageReadException.class, () -> new PngChunkScal(9, 1933787468, 0, new byte[]{1, 48, 46, 48, 49, 48, 46, 48, 50}));
    }

    @Test
    public void testConstruct_InvalidDblValue() {
        Assertions.assertThrows(ImageReadException.class, () -> new PngChunkScal(10, 1933787468, 0, new byte[]{2, 65, 46, 48, 49, 0, 48, 46, 48, 50}));
    }

    @Test
    public void testConstruct_MissingXValue() {
        Assertions.assertThrows(ImageReadException.class, () -> new PngChunkScal(2, 1933787468, 0, new byte[]{2, 0}));
    }

    @Test
    public void testConstruct_MissingYValue() {
        Assertions.assertThrows(ImageReadException.class, () -> new PngChunkScal(6, 1933787468, 0, new byte[]{2, 48, 46, 48, 49, 0}));
    }
}

