/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.file.Path;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.formats.tiff.TiffElement;
import org.apache.commons.imaging.formats.tiff.TiffImageData;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.write.TiffImageWriterLossy;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TiffAlphaRoundTripTest {
    @TempDir
    Path tempDir;

    @Test
    public void test() throws Exception {
        for (int i = 0; i < 2; ++i) {
            int width = 400;
            int height = 400;
            BufferedImage image0 = i == 0 ? new BufferedImage(400, 400, 2) : new BufferedImage(400, 400, 1);
            Graphics2D g2d = image0.createGraphics();
            g2d.setColor(Color.red);
            g2d.fillRect(0, 0, 400, 400);
            g2d.setComposite(AlphaComposite.getInstance(2));
            g2d.setColor(new Color(0, 0, 0, 0));
            g2d.fillRect(100, 100, 100, 100);
            g2d.setColor(new Color(255, 0, 0, 128));
            g2d.fillRect(200, 200, 100, 100);
            File file = new File(this.tempDir.toFile(), "TiffAlphaRoundTripTest.tif");
            file.delete();
            Imaging.writeImage((BufferedImage)image0, (File)file, (ImageFormat)ImageFormats.TIFF);
            BufferedImage image1 = Imaging.getBufferedImage((File)file);
            BufferedImage compImage = new BufferedImage(400, 400, 2);
            g2d = compImage.createGraphics();
            g2d.setColor(Color.white);
            g2d.fillRect(0, 0, 400, 400);
            g2d.drawImage((Image)image1, 0, 0, null);
            int test1 = compImage.getRGB(150, 150);
            int test2 = compImage.getRGB(250, 250);
            if (i == 0) {
                this.doPixelsMatch(150, 150, -1, test1);
                this.doPixelsMatch(250, 250, -32897, test2);
                continue;
            }
            this.doPixelsMatch(151, 151, -16777216, test1);
            this.doPixelsMatch(251, 251, -65536, test2);
        }
    }

    void doPixelsMatch(int x, int y, int a, int b) {
        if (!(this.componentMatch(a, b, 0, 2) && this.componentMatch(a, b, 8, 2) && this.componentMatch(a, b, 16, 2) && this.componentMatch(a, b, 24, 2))) {
            String complaint = String.format("Pixel mismatch at (%d,%d): 0x%08x 0x%08x", x, y, a, b);
            Assertions.fail((String)complaint);
        }
    }

    boolean componentMatch(int a, int b, int iShift, int iTolerance) {
        int delta = (a >> iShift & 0xFF) - (b >> iShift & 0xFF);
        if (delta < 0) {
            delta = -delta;
        }
        return delta < iTolerance;
    }

    @Test
    void testExtraSamples() throws Exception {
        int bytesPerSample = 4;
        int width = 10;
        int height = 10;
        int nBytesPerStrip = 400;
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        int[] samples = new int[100];
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                int index = i * 10 + j;
                samples[index] = j > i ? -65536 : -1996554240;
            }
        }
        for (int iExtra = 0; iExtra < 3; ++iExtra) {
            TiffOutputSet outputSet = new TiffOutputSet(byteOrder);
            TiffOutputDirectory outDir = outputSet.addRootDirectory();
            outDir.add(TiffTagConstants.TIFF_TAG_IMAGE_WIDTH, new int[]{10});
            outDir.add(TiffTagConstants.TIFF_TAG_IMAGE_LENGTH, new int[]{10});
            outDir.add(TiffTagConstants.TIFF_TAG_SAMPLES_PER_PIXEL, (short)4);
            outDir.add(TiffTagConstants.TIFF_TAG_BITS_PER_SAMPLE, new short[]{8, 8, 8, 8});
            outDir.add(TiffTagConstants.TIFF_TAG_PHOTOMETRIC_INTERPRETATION, (short)2);
            outDir.add(TiffTagConstants.TIFF_TAG_COMPRESSION, (short)1);
            outDir.add(TiffTagConstants.TIFF_TAG_PLANAR_CONFIGURATION, (short)1);
            outDir.add(TiffTagConstants.TIFF_TAG_ROWS_PER_STRIP, new int[]{10});
            outDir.add(TiffTagConstants.TIFF_TAG_STRIP_BYTE_COUNTS, new int[]{400});
            outDir.add(TiffTagConstants.TIFF_TAG_EXTRA_SAMPLES, new short[]{(short)iExtra});
            byte[] b = new byte[400];
            int k = 0;
            for (int sample : samples) {
                b[k++] = (byte)(sample >> 16 & 0xFF);
                b[k++] = (byte)(sample >> 8 & 0xFF);
                b[k++] = (byte)(sample & 0xFF);
                b[k++] = (byte)(sample >> 24 & 0xFF);
            }
            TiffElement.DataElement[] imageData = new TiffElement.DataElement[]{new TiffImageData.Data(0L, b.length, b)};
            TiffImageData.Strips tiffImageData = new TiffImageData.Strips(imageData, 10);
            outDir.setTiffImageData((TiffImageData)tiffImageData);
            File outputFile = new File(this.tempDir.toFile(), "TestExtraSamples" + iExtra + ".tiff");
            try (FileOutputStream fos = new FileOutputStream(outputFile);
                 BufferedOutputStream bos = new BufferedOutputStream(fos);){
                TiffImageWriterLossy writer = new TiffImageWriterLossy(byteOrder);
                writer.write((OutputStream)bos, outputSet);
                bos.flush();
            }
            BufferedImage result = Imaging.getBufferedImage((File)outputFile);
            int[] argb = new int[samples.length];
            result.getRGB(0, 0, 10, 10, argb, 0, 10);
            int index = 31;
            int iSample = samples[index];
            int iArgb = argb[index];
            if (iExtra == 0) {
                iSample |= 0xFF000000;
            } else if (iExtra == 1) {
                iSample = -1981939712;
            }
            String p = String.format("%08x", iSample);
            String q = String.format("%08x", iArgb);
            Assertions.assertEquals((Object)p, (Object)q, (String)("Failure on ExtraSamples=" + iExtra));
        }
    }
}

