/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.file.Path;
import org.apache.commons.imaging.FormatCompliance;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceFile;
import org.apache.commons.imaging.formats.tiff.TiffBaseTest;
import org.apache.commons.imaging.formats.tiff.TiffContents;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.TiffElement;
import org.apache.commons.imaging.formats.tiff.TiffImageData;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.apache.commons.imaging.formats.tiff.TiffReader;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreter;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.floatingpoint.PhotometricInterpreterFloat;
import org.apache.commons.imaging.formats.tiff.write.TiffImageWriterLossy;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TiffFloatingPointRoundTripTest
extends TiffBaseTest {
    @TempDir
    Path tempDir;
    int width = 48;
    int height = 23;
    float f0 = 0.0f;
    float f1 = 1.0f;
    float[] f = new float[this.width * this.height];
    int[] argb = new int[this.width * this.height];

    public TiffFloatingPointRoundTripTest() {
        for (int iCol = 0; iCol < this.width; ++iCol) {
            float s = (float)iCol / (float)(this.width - 1);
            for (int iRow = 0; iRow < this.height; ++iRow) {
                int index = iRow * this.width + iCol;
                this.f[index] = s;
            }
        }
        try {
            PhotometricInterpreterFloat pi = this.getPhotometricInterpreter();
            ImageBuilder builder = new ImageBuilder(this.width, this.height, false);
            int[] samples = new int[1];
            for (int iCol = 0; iCol < this.width; ++iCol) {
                for (int iRow = 0; iRow < this.height; ++iRow) {
                    int index = iRow * this.width + iCol;
                    samples[0] = Float.floatToRawIntBits(this.f[index]);
                    pi.interpretPixel(builder, samples, iCol, iRow);
                    this.argb[index] = builder.getRGB(iCol, iRow);
                }
            }
        }
        catch (IOException | ImageReadException ex) {
            Assertions.fail((String)("Exception initializing data " + ex.getMessage()));
        }
    }

    private PhotometricInterpreterFloat getPhotometricInterpreter() {
        return new PhotometricInterpreterFloat(this.f0, this.f1 + 1.0E-5f);
    }

    @Test
    public void test() throws Exception {
        File[] testFile = new File[]{this.writeFile(32, ByteOrder.LITTLE_ENDIAN, false), this.writeFile(64, ByteOrder.LITTLE_ENDIAN, false), this.writeFile(32, ByteOrder.BIG_ENDIAN, false), this.writeFile(64, ByteOrder.BIG_ENDIAN, false), this.writeFile(32, ByteOrder.LITTLE_ENDIAN, true), this.writeFile(64, ByteOrder.LITTLE_ENDIAN, true), this.writeFile(32, ByteOrder.BIG_ENDIAN, true), this.writeFile(64, ByteOrder.BIG_ENDIAN, true)};
        for (int i = 0; i < testFile.length; ++i) {
            String name = testFile[i].getName();
            ByteSourceFile byteSource = new ByteSourceFile(testFile[i]);
            TiffReader tiffReader = new TiffReader(true);
            TiffContents contents = tiffReader.readDirectories((ByteSource)byteSource, true, FormatCompliance.getDefault());
            TiffDirectory directory = (TiffDirectory)contents.directories.get(0);
            PhotometricInterpreterFloat pi = this.getPhotometricInterpreter();
            TiffImagingParameters params = new TiffImagingParameters();
            params.setCustomPhotometricInterpreter((PhotometricInterpreter)pi);
            ByteOrder byteOrder = tiffReader.getByteOrder();
            BufferedImage bImage = directory.getTiffImage(byteOrder, params);
            Assertions.assertNotNull((Object)bImage, (String)("Failed to get image from " + name));
            int[] pixel = new int[this.width * this.height];
            bImage.getRGB(0, 0, this.width, this.height, pixel, 0, this.width);
            for (int k = 0; k < pixel.length; ++k) {
                Assertions.assertEquals((int)this.argb[k], (int)pixel[k], (String)("Extracted data does not match original, test " + i + ", index " + k));
            }
            float meanValue = pi.getMeanFound();
            Assertions.assertEquals((double)0.5, (double)meanValue, (double)1.0E-5, (String)("Invalid numeric values in " + name));
        }
    }

    private File writeFile(int bitsPerSample, ByteOrder byteOrder, boolean useTiles) throws IOException, ImageWriteException {
        int nColsInBlock;
        int nRowsInBlock;
        String name = String.format("FpRoundTrip_%2d_%s_%s.tiff", bitsPerSample, byteOrder == ByteOrder.LITTLE_ENDIAN ? "LE" : "BE", useTiles ? "Tiles" : "Strips");
        File outputFile = new File(this.tempDir.toFile(), name);
        int bytesPerSample = bitsPerSample / 8;
        if (useTiles) {
            nRowsInBlock = 12;
            nColsInBlock = 20;
        } else {
            nRowsInBlock = 2;
            nColsInBlock = this.width;
        }
        int nBytesInBlock = nRowsInBlock * nColsInBlock * bytesPerSample;
        byte[][] blocks = bitsPerSample == 32 ? this.getBytesForOutput32(this.f, this.width, this.height, nRowsInBlock, nColsInBlock, byteOrder) : this.getBytesForOutput64(this.f, this.width, this.height, nRowsInBlock, nColsInBlock, byteOrder);
        TiffOutputSet outputSet = new TiffOutputSet(byteOrder);
        TiffOutputDirectory outDir = outputSet.addRootDirectory();
        outDir.add(TiffTagConstants.TIFF_TAG_IMAGE_WIDTH, new int[]{this.width});
        outDir.add(TiffTagConstants.TIFF_TAG_IMAGE_LENGTH, new int[]{this.height});
        outDir.add(TiffTagConstants.TIFF_TAG_SAMPLE_FORMAT, new short[]{3});
        outDir.add(TiffTagConstants.TIFF_TAG_SAMPLES_PER_PIXEL, (short)1);
        outDir.add(TiffTagConstants.TIFF_TAG_BITS_PER_SAMPLE, new short[]{(short)bitsPerSample});
        outDir.add(TiffTagConstants.TIFF_TAG_PHOTOMETRIC_INTERPRETATION, (short)1);
        outDir.add(TiffTagConstants.TIFF_TAG_COMPRESSION, (short)1);
        outDir.add(TiffTagConstants.TIFF_TAG_PLANAR_CONFIGURATION, (short)1);
        if (useTiles) {
            outDir.add(TiffTagConstants.TIFF_TAG_TILE_WIDTH, new int[]{nColsInBlock});
            outDir.add(TiffTagConstants.TIFF_TAG_TILE_LENGTH, new int[]{nRowsInBlock});
            outDir.add(TiffTagConstants.TIFF_TAG_TILE_BYTE_COUNTS, new int[]{nBytesInBlock});
        } else {
            outDir.add(TiffTagConstants.TIFF_TAG_ROWS_PER_STRIP, new int[]{2});
            outDir.add(TiffTagConstants.TIFF_TAG_STRIP_BYTE_COUNTS, new int[]{nBytesInBlock});
        }
        TiffElement.DataElement[] imageData = new TiffElement.DataElement[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            imageData[i] = new TiffImageData.Data(0L, blocks[i].length, blocks[i]);
        }
        Object tiffImageData = useTiles ? new TiffImageData.Tiles(imageData, nColsInBlock, nRowsInBlock) : new TiffImageData.Strips(imageData, nRowsInBlock);
        outDir.setTiffImageData((TiffImageData)tiffImageData);
        try (FileOutputStream fos = new FileOutputStream(outputFile);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            TiffImageWriterLossy writer = new TiffImageWriterLossy(byteOrder);
            writer.write((OutputStream)bos, outputSet);
            bos.flush();
        }
        return outputFile;
    }

    private byte[][] getBytesForOutput32(float[] f, int width, int height, int nRowsInBlock, int nColsInBlock, ByteOrder byteOrder) {
        int nColsOfBlocks = (width + nColsInBlock - 1) / nColsInBlock;
        int nRowsOfBlocks = (height + nRowsInBlock + 1) / nRowsInBlock;
        int bytesPerPixel = 4;
        int nBlocks = nRowsOfBlocks * nColsOfBlocks;
        int nBytesInBlock = 4 * nRowsInBlock * nColsInBlock;
        byte[][] blocks = new byte[nBlocks][nBytesInBlock];
        for (int i = 0; i < height; ++i) {
            int blockRow = i / nRowsInBlock;
            int rowInBlock = i - blockRow * nRowsInBlock;
            int blockOffset = rowInBlock * nColsInBlock;
            for (int j = 0; j < width; ++j) {
                int sample = Float.floatToRawIntBits(f[i * width + j]);
                int blockCol = j / nColsInBlock;
                int colInBlock = j - blockCol * nColsInBlock;
                int index = blockOffset + colInBlock;
                int offset = index * 4;
                byte[] b = blocks[blockRow * nColsOfBlocks + blockCol];
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    b[offset] = (byte)(sample & 0xFF);
                    b[offset + 1] = (byte)(sample >> 8 & 0xFF);
                    b[offset + 2] = (byte)(sample >> 16 & 0xFF);
                    b[offset + 3] = (byte)(sample >> 24 & 0xFF);
                    continue;
                }
                b[offset] = (byte)(sample >> 24 & 0xFF);
                b[offset + 1] = (byte)(sample >> 16 & 0xFF);
                b[offset + 2] = (byte)(sample >> 8 & 0xFF);
                b[offset + 3] = (byte)(sample & 0xFF);
            }
        }
        return blocks;
    }

    private byte[][] getBytesForOutput64(float[] f, int width, int height, int nRowsInBlock, int nColsInBlock, ByteOrder byteOrder) {
        int nColsOfBlocks = (width + nColsInBlock - 1) / nColsInBlock;
        int nRowsOfBlocks = (height + nRowsInBlock + 1) / nRowsInBlock;
        int bytesPerPixel = 8;
        int nBlocks = nRowsOfBlocks * nColsOfBlocks;
        int nBytesInBlock = 8 * nRowsInBlock * nColsInBlock;
        byte[][] blocks = new byte[nBlocks][nBytesInBlock];
        for (int i = 0; i < height; ++i) {
            int blockRow = i / nRowsInBlock;
            int rowInBlock = i - blockRow * nRowsInBlock;
            int blockOffset = rowInBlock * nColsInBlock;
            for (int j = 0; j < width; ++j) {
                long sample = Double.doubleToRawLongBits(f[i * width + j]);
                int blockCol = j / nColsInBlock;
                int colInBlock = j - blockCol * nColsInBlock;
                int index = blockOffset + colInBlock;
                int offset = index * 8;
                byte[] b = blocks[blockRow * nColsOfBlocks + blockCol];
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    b[offset] = (byte)(sample & 0xFFL);
                    b[offset + 1] = (byte)(sample >> 8 & 0xFFL);
                    b[offset + 2] = (byte)(sample >> 16 & 0xFFL);
                    b[offset + 3] = (byte)(sample >> 24 & 0xFFL);
                    b[offset + 4] = (byte)(sample >> 32 & 0xFFL);
                    b[offset + 5] = (byte)(sample >> 40 & 0xFFL);
                    b[offset + 6] = (byte)(sample >> 48 & 0xFFL);
                    b[offset + 7] = (byte)(sample >> 56 & 0xFFL);
                    continue;
                }
                b[offset] = (byte)(sample >> 56 & 0xFFL);
                b[offset + 1] = (byte)(sample >> 48 & 0xFFL);
                b[offset + 2] = (byte)(sample >> 40 & 0xFFL);
                b[offset + 3] = (byte)(sample >> 32 & 0xFFL);
                b[offset + 4] = (byte)(sample >> 24 & 0xFFL);
                b[offset + 5] = (byte)(sample >> 16 & 0xFFL);
                b[offset + 6] = (byte)(sample >> 8 & 0xFFL);
                b[offset + 7] = (byte)(sample & 0xFFL);
            }
        }
        return blocks;
    }
}

