/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.util.Arrays;
import org.apache.commons.imaging.formats.tiff.TiffRasterData;
import org.apache.commons.imaging.formats.tiff.TiffRasterDataFloat;
import org.apache.commons.imaging.formats.tiff.TiffRasterStatistics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TiffRasterStatisticsTest {
    int width = 11;
    int height = 10;
    float[] data;
    TiffRasterData raster;
    float meanValue;
    TiffRasterStatistics stat0;
    TiffRasterStatistics stat1;

    public TiffRasterStatisticsTest() {
        double sum = 0.0;
        this.data = new float[this.width * this.height];
        int k = 0;
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                this.data[k] = k;
                sum += (double)k;
                ++k;
            }
        }
        this.data[this.width * this.height / 2] = Float.NaN;
        this.raster = new TiffRasterDataFloat(this.width, this.height, this.data);
        this.meanValue = (float)(sum / (double)k);
        this.stat0 = this.raster.getSimpleStatistics();
        this.stat1 = this.raster.getSimpleStatistics(this.stat0.getMaxValue());
    }

    @Test
    public void testGetCountOfSamples() {
        Assertions.assertEquals((int)(this.width * this.height - 1), (int)this.stat0.getCountOfSamples());
        Assertions.assertEquals((int)(this.width * this.height - 2), (int)this.stat1.getCountOfSamples());
    }

    @Test
    public void testGetCountOfNulls() {
        Assertions.assertEquals((int)1, (int)this.stat0.getCountOfNulls());
        Assertions.assertEquals((int)1, (int)this.stat1.getCountOfNulls());
    }

    @Test
    public void testGetMinValue() {
        Assertions.assertEquals((float)0.0f, (float)this.stat0.getMinValue());
        Assertions.assertEquals((float)0.0f, (float)this.stat1.getMinValue());
    }

    @Test
    public void testGetMaxValue() {
        Assertions.assertEquals((float)(this.width * this.height - 1), (float)this.stat0.getMaxValue());
        Assertions.assertEquals((float)(this.width * this.height - 2), (float)this.stat1.getMaxValue());
    }

    @Test
    public void testGetMeanValue() {
        Assertions.assertNotEquals((float)0.0f, (float)this.stat0.getMeanValue());
        float[] zero = new float[100];
        Arrays.fill(zero, 10.0f);
        TiffRasterDataFloat zeroData = new TiffRasterDataFloat(10, 10, zero);
        TiffRasterStatistics zeroStat = zeroData.getSimpleStatistics(10.0f);
        Assertions.assertEquals((float)0.0f, (float)zeroStat.getMeanValue(), (String)"Invalid mean data for excluded value");
    }

    @Test
    public void testIsAnExcludedValueSet() {
        Assertions.assertFalse((boolean)this.stat0.isAnExcludedValueSet());
        Assertions.assertTrue((boolean)this.stat1.isAnExcludedValueSet());
    }

    @Test
    public void testGetExcludedValue() {
        Assertions.assertTrue((boolean)Float.isNaN(this.stat0.getExcludedValue()));
        Assertions.assertEquals((float)(this.width * this.height - 1), (float)this.stat1.getExcludedValue());
    }
}

