/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingTestConstants;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TiffReadAlphaTest {
    private static final String[] names = new String[]{"TransparencyTestStripAssociated.tif", "TransparencyTestStripUnassociated.tif", "TransparencyTestTileAssociated.tif", "TransparencyTestTileUnassociated.tif"};
    private static final int[][] testSite = new int[][]{{40, 40, -65536}, {60, 40, -8913033}, {40, 60, -65536}, {60, 60, -16742400}};

    private File getTiffFile(String name) {
        File tiffFolder = new File(ImagingTestConstants.TEST_IMAGE_FOLDER, "tiff");
        File alphaFolder = new File(tiffFolder, "12");
        return new File(alphaFolder, name);
    }

    @Test
    public void test() {
        for (String name : names) {
            try {
                File subject = this.getTiffFile(name);
                BufferedImage overlay = Imaging.getBufferedImage((File)subject);
                BufferedImage composite = new BufferedImage(100, 100, 2);
                Graphics2D g2d = composite.createGraphics();
                g2d.setColor(Color.white);
                g2d.fillRect(0, 0, 101, 101);
                g2d.setColor(Color.black);
                g2d.fillRect(0, 50, 101, 51);
                g2d.drawImage((Image)overlay, 0, 0, null);
                for (int[] element : testSite) {
                    int x = element[0];
                    int y = element[1];
                    int p = element[2];
                    int t = composite.getRGB(x, y);
                    Assertions.assertEquals((int)t, (int)p, (String)("Error for " + name + " at position " + x + ", " + y));
                }
            }
            catch (IOException | ImageReadException ex) {
                Assertions.fail((String)("Exception reading " + name + ", " + ex.getMessage()));
            }
        }
    }
}

