/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import org.apache.commons.imaging.FormatCompliance;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceFile;
import org.apache.commons.imaging.formats.tiff.TiffBaseTest;
import org.apache.commons.imaging.formats.tiff.TiffContents;
import org.apache.commons.imaging.formats.tiff.TiffReader;
import org.apache.commons.imaging.internal.Debug;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TiffReadTest
extends TiffBaseTest {
    @Test
    public void test() throws Exception {
        List<File> images = this.getTiffImages();
        for (File imageFile : images) {
            Debug.debug((String)"imageFile", (Object)imageFile);
            ImageMetadata metadata = Imaging.getMetadata((File)imageFile);
            Assertions.assertNotNull((Object)metadata);
            Debug.debug((String)"ICC profile", (Object)Imaging.getICCProfile((File)imageFile));
            ImageInfo imageInfo = Imaging.getImageInfo((File)imageFile);
            Assertions.assertNotNull((Object)imageInfo);
            BufferedImage image = Imaging.getBufferedImage((File)imageFile);
            Assertions.assertNotNull((Object)image);
        }
    }

    @Test
    public void testReadDirectories() throws Exception {
        List<File> images = this.getTiffImages();
        for (File imageFile : images) {
            String name = imageFile.getName();
            if (name.toLowerCase().contains("bad")) continue;
            ByteSourceFile byteSource = new ByteSourceFile(imageFile);
            TiffReader tiffReader = new TiffReader(true);
            TiffContents contents = tiffReader.readDirectories((ByteSource)byteSource, true, FormatCompliance.getDefault());
            Assertions.assertNotNull((Object)contents);
        }
    }
}

