/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.imaging.FormatCompliance;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceArray;
import org.apache.commons.imaging.formats.tiff.TiffBaseTest;
import org.apache.commons.imaging.formats.tiff.TiffContents;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.TiffReader;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.GeoTiffTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.GpsTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.MicrosoftHdPhotoTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.write.TiffImageWriterLossy;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TiffReadWriteTagsTest
extends TiffBaseTest {
    @Test
    public void testReadWriteTags() throws ImageWriteException, ImageReadException, IOException {
        String description = "A pretty picture";
        boolean page = true;
        RationalNumber twoThirds = new RationalNumber(2, 3);
        boolean t4Options = false;
        int width = 10;
        int height = 10;
        String area = "A good area";
        float widthRes = 2.2f;
        double geoDoubleParams = -8.4;
        RationalNumber exposureCompensation = new RationalNumber(-17, 10);
        RationalNumber[] latitude = new RationalNumber[]{new RationalNumber(38, 1, true), new RationalNumber(36, 1, true), new RationalNumber(-174884066, 70000000, true)};
        TiffOutputSet set = new TiffOutputSet();
        TiffOutputDirectory dir = set.getOrCreateRootDirectory();
        dir.add(TiffTagConstants.TIFF_TAG_IMAGE_DESCRIPTION, new String[]{"A pretty picture"});
        dir.add(TiffTagConstants.TIFF_TAG_PAGE_NUMBER, new short[]{1, 1});
        dir.add(TiffTagConstants.TIFF_TAG_YRESOLUTION, twoThirds);
        dir.add(TiffTagConstants.TIFF_TAG_T4_OPTIONS, 0);
        dir.add(TiffTagConstants.TIFF_TAG_IMAGE_WIDTH, new int[]{10});
        dir.add(TiffTagConstants.TIFF_TAG_IMAGE_LENGTH, new short[]{10});
        dir.add(GpsTagConstants.GPS_TAG_GPS_AREA_INFORMATION, "A good area");
        dir.add(MicrosoftHdPhotoTagConstants.EXIF_TAG_WIDTH_RESOLUTION, 2.2f);
        dir.add(GeoTiffTagConstants.EXIF_TAG_GEO_DOUBLE_PARAMS_TAG, new double[]{-8.4});
        dir.add(ExifTagConstants.EXIF_TAG_EXPOSURE_COMPENSATION, exposureCompensation);
        dir.add(GpsTagConstants.GPS_TAG_GPS_LATITUDE, latitude);
        TiffImageWriterLossy writer = new TiffImageWriterLossy();
        ByteArrayOutputStream tiff = new ByteArrayOutputStream();
        writer.write((OutputStream)tiff, set);
        TiffReader reader = new TiffReader(true);
        FormatCompliance formatCompliance = new FormatCompliance("");
        TiffContents contents = reader.readDirectories((ByteSource)new ByteSourceArray(tiff.toByteArray()), true, formatCompliance);
        TiffDirectory rootDir = (TiffDirectory)contents.directories.get(0);
        Assertions.assertEquals((Object)"A pretty picture", (Object)rootDir.getSingleFieldValue(TiffTagConstants.TIFF_TAG_IMAGE_DESCRIPTION));
        Assertions.assertEquals((short)1, (short)rootDir.getFieldValue(TiffTagConstants.TIFF_TAG_PAGE_NUMBER, true)[0]);
        RationalNumber yRes = rootDir.getFieldValue(TiffTagConstants.TIFF_TAG_YRESOLUTION);
        Assertions.assertEquals((long)twoThirds.numerator, (long)yRes.numerator);
        Assertions.assertEquals((long)twoThirds.divisor, (long)yRes.divisor);
        Assertions.assertEquals((int)0, (int)rootDir.getFieldValue(TiffTagConstants.TIFF_TAG_T4_OPTIONS));
        Assertions.assertEquals((int)10, (int)rootDir.getSingleFieldValue(TiffTagConstants.TIFF_TAG_IMAGE_WIDTH));
        Assertions.assertEquals((int)10, (int)rootDir.getSingleFieldValue(TiffTagConstants.TIFF_TAG_IMAGE_LENGTH));
        Assertions.assertEquals((Object)"A good area", (Object)rootDir.getFieldValue(GpsTagConstants.GPS_TAG_GPS_AREA_INFORMATION, true));
        Assertions.assertEquals((double)2.2f, (double)rootDir.getFieldValue(MicrosoftHdPhotoTagConstants.EXIF_TAG_WIDTH_RESOLUTION), (double)0.0);
        Assertions.assertEquals((double)-8.4, (double)rootDir.getFieldValue(GeoTiffTagConstants.EXIF_TAG_GEO_DOUBLE_PARAMS_TAG, true)[0], (double)0.0);
        Assertions.assertEquals((double)exposureCompensation.doubleValue(), (double)rootDir.getFieldValue(ExifTagConstants.EXIF_TAG_EXPOSURE_COMPENSATION).doubleValue(), (double)0.0);
        RationalNumber[] testLat = rootDir.getFieldValue(GpsTagConstants.GPS_TAG_GPS_LATITUDE, true);
        for (int i = 0; i < 3; ++i) {
            Assertions.assertEquals((double)latitude[i].doubleValue(), (double)testLat[i].doubleValue(), (double)0.0);
        }
    }
}

