/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.tiff.TiffBaseTest;
import org.apache.commons.imaging.formats.tiff.TiffImageParser;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.apache.commons.imaging.internal.Debug;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TiffRoundtripTest
extends TiffBaseTest {
    @Test
    public void test() throws Exception {
        List<File> images = this.getTiffImages();
        for (File imageFile : images) {
            Debug.debug((String)"imageFile", (Object)imageFile);
            ImageMetadata metadata = Imaging.getMetadata((File)imageFile);
            Assertions.assertNotNull((Object)metadata);
            ImageInfo imageInfo = Imaging.getImageInfo((File)imageFile);
            Assertions.assertNotNull((Object)imageInfo);
            BufferedImage image = Imaging.getBufferedImage((File)imageFile);
            Assertions.assertNotNull((Object)image);
            int[] compressions = new int[]{1, 5, 32773, 8};
            TiffImageParser tiffImageParser = new TiffImageParser();
            for (int compression : compressions) {
                File tempFile = File.createTempFile(imageFile.getName() + "-" + compression + ".", ".tif");
                TiffImagingParameters params = new TiffImagingParameters();
                params.setCompression(Integer.valueOf(compression));
                try (FileOutputStream fos = new FileOutputStream(tempFile);){
                    tiffImageParser.writeImage(image, (OutputStream)fos, params);
                }
                BufferedImage image2 = Imaging.getBufferedImage((File)tempFile);
                Assertions.assertNotNull((Object)image2);
            }
        }
    }
}

