/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingParameters;
import org.apache.commons.imaging.formats.tiff.TiffBaseTest;
import org.apache.commons.imaging.formats.tiff.TiffImageParser;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TiffSubImageTest
extends TiffBaseTest {
    final List<File> imageFileList = this.getTiffImages();

    TiffSubImageTest() throws IOException, ImageReadException {
    }

    @Test
    public void testSubImage() throws ImageReadException, ImageWriteException, IOException {
        byte[] imageBytes;
        TiffImageParser tiffImageParser = new TiffImageParser();
        BufferedImage src = new BufferedImage(10, 10, 1);
        TiffImagingParameters params = new TiffImagingParameters();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            tiffImageParser.writeImage(src, (OutputStream)baos, params);
            imageBytes = baos.toByteArray();
        }
        params.setSubImage(0, 0, 2, 3);
        BufferedImage image = tiffImageParser.getBufferedImage(imageBytes, (ImagingParameters)params);
        Assertions.assertEquals((int)image.getWidth(), (int)2);
        Assertions.assertEquals((int)image.getHeight(), (int)3);
    }

    @Test
    public void testBadSubImage() throws ImageReadException, IOException {
        TiffImageParser tiffImageParser = new TiffImageParser();
        File target = this.imageFileList.get(0);
        BufferedImage referenceImage = Imaging.getBufferedImage((File)target);
        int width = referenceImage.getWidth();
        int height = referenceImage.getHeight();
        TiffImagingParameters params = new TiffImagingParameters();
        params.setSubImage(0, 0, width, height);
        BufferedImage image = tiffImageParser.getBufferedImage(target, (ImagingParameters)params);
        Assertions.assertEquals((int)image.getWidth(), (int)width, (String)"Improper width when sub-imaging entire image");
        Assertions.assertEquals((int)image.getHeight(), (int)height, (String)"Improper height when sub-imaging entire image");
        this.processBadParams(target, -1, 0, width, height, "negative x position");
        this.processBadParams(target, 0, -1, width, height, "negative y position");
        this.processBadParams(target, 0, 0, 0, height, "zero width");
        this.processBadParams(target, 0, 0, width, 0, "zero height");
        this.processBadParams(target, 1, 0, width, height, "sub-image width extends beyond bounds");
        this.processBadParams(target, 0, 1, width, height, "sub-image height extends beyond bounds");
    }

    private void processBadParams(File target, int x, int y, int width, int height, String comment) throws IOException {
        TiffImageParser tiffImageParser = new TiffImageParser();
        try {
            TiffImagingParameters params = new TiffImagingParameters();
            params.setSubImage(x, y, width, height);
            tiffImageParser.getBufferedImage(target, (ImagingParameters)params);
            Assertions.fail((String)("Reading TIFF sub-image failed to detect bad parameter: " + comment));
        }
        catch (IllegalArgumentException | ImageReadException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testSubImageCorrectness() throws ImageReadException, IOException {
        TiffImageParser tiffImageParser = new TiffImageParser();
        for (File target : this.imageFileList) {
            BufferedImage referenceImage = Imaging.getBufferedImage((File)target);
            int rW = referenceImage.getWidth();
            int rH = referenceImage.getHeight();
            if (rW < 3 || rH < 3) continue;
            int[] rArgb = new int[rW * rH];
            referenceImage.getRGB(0, 0, rW, rH, rArgb, 0, rW);
            TiffImagingParameters params = new TiffImagingParameters();
            params.setSubImage(1, 1, rW - 2, rH - 2);
            BufferedImage image = tiffImageParser.getBufferedImage(target, (ImagingParameters)params);
            int iW = image.getWidth();
            int iH = image.getHeight();
            Assertions.assertEquals((int)iW, (int)(rW - 2), (String)"Invalid subimage width");
            Assertions.assertEquals((int)iH, (int)(rH - 2), (String)"Invalid subimage height");
            int[] iArgb = new int[iW * iH];
            image.getRGB(0, 0, iW, iH, iArgb, 0, iW);
            for (int i = 0; i < iH; ++i) {
                for (int j = 0; j < iW; ++j) {
                    int rTest = rArgb[(i + 1) * rW + j + 1];
                    int iTest = iArgb[i * iW + j];
                    Assertions.assertEquals((int)iTest, (int)rTest, (String)("Invalid pixel lookup for " + target.getName() + " at " + i + ", " + j));
                }
            }
        }
    }
}

