/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.imaging.ImagingTest;
import org.apache.commons.imaging.formats.tiff.constants.AdobePageMaker6TagConstants;
import org.apache.commons.imaging.formats.tiff.constants.AdobePhotoshopTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.AliasSketchbookProTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.DcfTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.DngTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.GdalLibraryTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.GeoTiffTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.GpsTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.MicrosoftHdPhotoTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.MicrosoftTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.MolecularDynamicsGelTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.OceScanjobTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.Rfc2301TagConstants;
import org.apache.commons.imaging.formats.tiff.constants.Tiff4TagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffEpTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.WangTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TiffTagIntegrityTest
extends ImagingTest {
    @Test
    public void testTagIntegrity() {
        this.verifyFields(AdobePageMaker6TagConstants.class, AdobePageMaker6TagConstants.ALL_ADOBE_PAGEMAKER_6_TAGS);
        this.verifyFields(AdobePhotoshopTagConstants.class, AdobePhotoshopTagConstants.ALL_ADOBE_PHOTOSHOP_TAGS);
        this.verifyFields(AliasSketchbookProTagConstants.class, AliasSketchbookProTagConstants.ALL_ALIAS_SKETCHBOOK_PRO_TAGS);
        this.verifyFields(DcfTagConstants.class, DcfTagConstants.ALL_DCF_TAGS);
        this.verifyFields(DngTagConstants.class, DngTagConstants.ALL_DNG_TAGS);
        this.verifyFields(ExifTagConstants.class, ExifTagConstants.ALL_EXIF_TAGS);
        this.verifyFields(GeoTiffTagConstants.class, GeoTiffTagConstants.ALL_GEO_TIFF_TAGS);
        this.verifyFields(GdalLibraryTagConstants.class, GdalLibraryTagConstants.ALL_GDAL_LIBRARY_TAGS);
        this.verifyFields(GpsTagConstants.class, GpsTagConstants.ALL_GPS_TAGS);
        this.verifyFields(MolecularDynamicsGelTagConstants.class, MolecularDynamicsGelTagConstants.ALL_MOLECULAR_DYNAMICS_GEL_TAGS);
        this.verifyFields(MicrosoftTagConstants.class, MicrosoftTagConstants.ALL_MICROSOFT_TAGS);
        this.verifyFields(MicrosoftHdPhotoTagConstants.class, MicrosoftHdPhotoTagConstants.ALL_MICROSOFT_HD_PHOTO_TAGS);
        this.verifyFields(OceScanjobTagConstants.class, OceScanjobTagConstants.ALL_OCE_SCANJOB_TAGS);
        this.verifyFields(Rfc2301TagConstants.class, Rfc2301TagConstants.ALL_RFC_2301_TAGS);
        this.verifyFields(Tiff4TagConstants.class, Tiff4TagConstants.ALL_TIFF_4_TAGS);
        this.verifyFields(TiffEpTagConstants.class, TiffEpTagConstants.ALL_TIFF_EP_TAGS);
        this.verifyFields(TiffTagConstants.class, TiffTagConstants.ALL_TIFF_TAGS);
        this.verifyFields(WangTagConstants.class, WangTagConstants.ALL_WANG_TAGS);
    }

    private void verifyFields(Class<?> cls, List<TagInfo> allTags) {
        ArrayList<Integer> fieldTags = new ArrayList<Integer>();
        for (Field field : cls.getFields()) {
            field.setAccessible(true);
            Object obj = null;
            try {
                obj = field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (obj == null || !(obj instanceof TagInfo)) continue;
            TagInfo src = (TagInfo)obj;
            if (src.tag == -1) continue;
            fieldTags.add(src.tag);
        }
        Collections.sort(fieldTags);
        TreeSet<Integer> allTagSet = new TreeSet<Integer>();
        for (TagInfo tagInfo : allTags) {
            Assertions.assertTrue((Collections.binarySearch(fieldTags, tagInfo.tag) >= 0 ? 1 : 0) != 0);
            allTagSet.add(tagInfo.tag);
        }
        for (Integer tag : fieldTags) {
            Assertions.assertTrue((boolean)allTagSet.contains(tag));
        }
    }
}

