/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.fieldtypes;

import java.nio.ByteOrder;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldType;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldTypeAscii;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FieldTypeAsciiTest {
    @Test
    public void testCreatesFieldTypeAsciiAndCallsWriteData() {
        FieldTypeAscii fieldTypeAscii = new FieldTypeAscii(0, "1\u007f");
        byte[] byteArray = new byte[1];
        ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        TiffField tiffField = new TiffField(0, 0, (FieldType)fieldTypeAscii, 0L, 0L, byteArray, byteOrder, 1);
        Assertions.assertThrows(ImageWriteException.class, () -> fieldTypeAscii.writeData((Object)tiffField, byteOrder));
    }

    @Test
    public void testCreatesFieldTypeAsciiAndWriteDataUsingByteArray() throws ImageWriteException {
        FieldTypeAscii fieldTypeAscii = new FieldTypeAscii(0, "1");
        byte[] byteArray = new byte[1];
        ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        byte[] byteArrayTwo = fieldTypeAscii.writeData((Object)byteArray, byteOrder);
        Assertions.assertArrayEquals((byte[])new byte[]{0, 0}, (byte[])byteArrayTwo);
    }

    @Test
    public void testCreatesFieldTypeAsciiAndWriteDataUsingString() throws ImageWriteException {
        FieldTypeAscii fieldTypeAscii = new FieldTypeAscii(0, "1");
        ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        byte[] byteArrayTwo = fieldTypeAscii.writeData((Object)"asdf", byteOrder);
        Assertions.assertArrayEquals((byte[])new byte[]{97, 115, 100, 102, 0}, (byte[])byteArrayTwo);
    }
}

