/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.photometricinterpreters;

import java.io.IOException;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreterLogLuv;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PhotometricInterpreterLogLuvTest {
    private PhotometricInterpreterLogLuv p;
    private final int samplesPerPixel = 8;
    private final int[] bitsPerSample = new int[]{1, 2, 3};
    private final int predictor = 1;
    private final int width = 800;
    private final int height = 600;

    @BeforeEach
    public void setUp() {
        this.p = new PhotometricInterpreterLogLuv(8, this.bitsPerSample, 1, 800, 600);
    }

    @Test
    public void testConstructor() {
        Assertions.assertEquals((int)8, (int)this.p.samplesPerPixel);
        for (int i = 0; i < this.bitsPerSample.length; ++i) {
            Assertions.assertEquals((int)this.bitsPerSample[i], (int)this.p.getBitsPerSample(i));
        }
        Assertions.assertEquals((int)1, (int)this.p.predictor);
        Assertions.assertEquals((int)800, (int)this.p.width);
        Assertions.assertEquals((int)600, (int)this.p.height);
    }

    @Test
    public void testGetTristimulusValues() {
        Assertions.assertEquals((double)0.0, (double)this.p.getTristimulusValues((int)0, (int)0, (int)0).x, (double)0.001);
        Assertions.assertEquals((double)0.0, (double)this.p.getTristimulusValues((int)0, (int)0, (int)0).y, (double)0.001);
        Assertions.assertEquals((double)0.0, (double)this.p.getTristimulusValues((int)0, (int)0, (int)0).z, (double)0.001);
        Assertions.assertEquals((double)0.04126, (double)this.p.getTristimulusValues((int)1, (int)0, (int)0).x, (double)0.001);
        Assertions.assertEquals((double)0.04341, (double)this.p.getTristimulusValues((int)1, (int)0, (int)0).y, (double)0.001);
        Assertions.assertEquals((double)0.04727, (double)this.p.getTristimulusValues((int)1, (int)0, (int)0).z, (double)0.001);
        Assertions.assertEquals((double)29.36116, (double)this.p.getTristimulusValues((int)100, (int)100, (int)50).x, (double)0.001);
        Assertions.assertEquals((double)10.78483, (double)this.p.getTristimulusValues((int)100, (int)100, (int)50).y, (double)0.001);
        Assertions.assertEquals((double)1.25681, (double)this.p.getTristimulusValues((int)100, (int)100, (int)50).z, (double)0.001);
    }

    @Test
    public void testGetRgbValues() {
        PhotometricInterpreterLogLuv.TristimulusValues triValues = new PhotometricInterpreterLogLuv.TristimulusValues();
        triValues.x = 0.0f;
        triValues.y = 0.0f;
        triValues.z = 0.0f;
        Assertions.assertEquals((int)0, (int)this.p.getRgbValues((PhotometricInterpreterLogLuv.TristimulusValues)triValues).r);
        Assertions.assertEquals((int)0, (int)this.p.getRgbValues((PhotometricInterpreterLogLuv.TristimulusValues)triValues).g);
        Assertions.assertEquals((int)0, (int)this.p.getRgbValues((PhotometricInterpreterLogLuv.TristimulusValues)triValues).b);
        triValues.x = 1.0f;
        triValues.y = 1.0f;
        triValues.z = 1.0f;
        Assertions.assertEquals((int)28, (int)this.p.getRgbValues((PhotometricInterpreterLogLuv.TristimulusValues)triValues).r);
        Assertions.assertEquals((int)24, (int)this.p.getRgbValues((PhotometricInterpreterLogLuv.TristimulusValues)triValues).g);
        Assertions.assertEquals((int)23, (int)this.p.getRgbValues((PhotometricInterpreterLogLuv.TristimulusValues)triValues).b);
    }

    @Test
    public void testInterpretPixelNullSamples() {
        Assertions.assertThrows(ImageReadException.class, () -> this.p.interpretPixel(null, null, 0, 0));
    }

    @Test
    public void testInterpretPixelEmptySamples() {
        Assertions.assertThrows(ImageReadException.class, () -> this.p.interpretPixel(null, new int[0], 0, 0));
    }

    @Test
    public void testInterpretPixel() throws ImageReadException, IOException {
        ImageBuilder imgBuilder = new ImageBuilder(600, 400, true);
        int x = 10;
        int y = 20;
        this.p.interpretPixel(imgBuilder, new int[]{100, 32, 2}, 10, 20);
        Assertions.assertEquals((int)-7584166, (int)imgBuilder.getRGB(10, 20));
    }
}

