/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.photometricinterpreters;

import java.io.IOException;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreterRgb;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PhotometricInterpreterRgbTest {
    private PhotometricInterpreterRgb p;
    private final int samplesPerPixel = 3;
    private final int[] bitsPerSample = new int[]{8, 8, 8};
    private final int predictor = 1;
    private final int width = 800;
    private final int height = 600;

    @BeforeEach
    public void setUp() {
        this.p = new PhotometricInterpreterRgb(3, this.bitsPerSample, 1, 800, 600);
    }

    @Test
    public void testConstructor() {
        Assertions.assertEquals((int)3, (int)this.p.samplesPerPixel);
        for (int i = 0; i < this.bitsPerSample.length; ++i) {
            Assertions.assertEquals((int)this.bitsPerSample[i], (int)this.p.getBitsPerSample(i));
        }
        Assertions.assertEquals((int)1, (int)this.p.predictor);
        Assertions.assertEquals((int)800, (int)this.p.width);
        Assertions.assertEquals((int)600, (int)this.p.height);
    }

    @Test
    public void testInterpretPixel() throws ImageReadException, IOException {
        ImageBuilder imgBuilder = new ImageBuilder(600, 400, true);
        int x = 10;
        int y = 20;
        this.p.interpretPixel(imgBuilder, new int[]{255, 255, 255}, 10, 20);
        Assertions.assertEquals((int)-1, (int)imgBuilder.getRGB(10, 20));
    }
}

