/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.photometricinterpreters.floatingpoint;

import java.awt.Color;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.floatingpoint.PaletteEntryForRange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PaletteEntryForRangeTest {
    @Test
    public void testIsCovered() {
        Color c0 = new Color(-16776961);
        Color c1 = new Color(-16711936);
        PaletteEntryForRange instance = new PaletteEntryForRange(0.0f, 1.0f, c0, c1);
        Assertions.assertTrue((boolean)instance.isCovered(0.0f), (String)"Zero value must be covered");
        Assertions.assertFalse((boolean)instance.isCovered(1.0f), (String)"Value 1.0 must not be covered");
    }

    @Test
    public void testGetARGB() {
        Color c0 = new Color(-16776961);
        Color c1 = new Color(-16711936);
        PaletteEntryForRange instance = new PaletteEntryForRange(0.0f, 1.0f, c0, c1);
        int a0 = instance.getARGB(0.0f);
        int a1 = instance.getARGB(0.5f);
        Assertions.assertEquals((int)-16776961, (int)a0, (String)"Invalid value for 0.0f");
        Assertions.assertEquals((int)-16744320, (int)a1, (String)"Invalid interpolated values");
    }

    @Test
    public void testGetColor() {
        Color c0 = new Color(-16776961);
        Color c1 = new Color(-16711936);
        PaletteEntryForRange instance = new PaletteEntryForRange(0.0f, 1.0f, c0, c1);
        c0 = instance.getColor(0.0f);
        c1 = instance.getColor(0.5f);
        int a0 = c0.getRGB();
        int a1 = c1.getRGB();
        Assertions.assertEquals((int)-16776961, (int)a0, (String)"Invalid value for 0.0f");
        Assertions.assertEquals((int)-16744320, (int)a1, (String)"Invalid interpolated values");
    }

    @Test
    public void testCoversSingleEntry() {
        Color c0 = new Color(-16776961);
        Color c1 = new Color(-16711936);
        PaletteEntryForRange instance = new PaletteEntryForRange(0.0f, 1.0f, c0, c1);
        Assertions.assertFalse((boolean)instance.coversSingleEntry());
    }

    @Test
    public void testGetLowerBound() {
        Color c0 = new Color(-16776961);
        Color c1 = new Color(-16711936);
        PaletteEntryForRange instance = new PaletteEntryForRange(0.0f, 1.0f, c0, c1);
        Assertions.assertEquals((float)0.0f, (float)instance.getLowerBound());
    }

    @Test
    public void testGetUpperBound() {
        Color c0 = new Color(-16776961);
        Color c1 = new Color(-16711936);
        PaletteEntryForRange instance = new PaletteEntryForRange(0.0f, 1.0f, c0, c1);
        Assertions.assertEquals((float)1.0f, (float)instance.getUpperBound());
    }

    @Test
    public void testFaultyConstructors() {
        PaletteEntryForRange pTest;
        Color c0 = new Color(-16776961);
        Color c1 = new Color(-16711936);
        try {
            pTest = new PaletteEntryForRange(0.0f, 0.0f, c0, c1);
            Assertions.fail((String)"Constructor failed to detect invalid range");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            pTest = new PaletteEntryForRange(0.0f, 1.0f, null, c1);
            Assertions.fail((String)"Constructor failed to detect null color");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            pTest = new PaletteEntryForRange(0.0f, 1.0f, c0, null);
            Assertions.fail((String)"Constructor failed to detect invalid color");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            pTest = new PaletteEntryForRange(0.0f, 0.0f, c0);
            Assertions.fail((String)"Constructor failed to detect invalid range");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            pTest = new PaletteEntryForRange(0.0f, 1.0f, null);
            Assertions.fail((String)"Constructor failed to detect null color");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

