/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.photometricinterpreters.floatingpoint;

import java.awt.Color;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.floatingpoint.PaletteEntryForValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PaletteEntryForValueTest {
    @Test
    public void testIsCovered() {
        Color c0 = new Color(-16776961);
        PaletteEntryForValue instance = new PaletteEntryForValue(0.0f, c0);
        Assertions.assertTrue((boolean)instance.isCovered(0.0f), (String)"Zero value must be covered");
        Assertions.assertFalse((boolean)instance.isCovered(1.0f), (String)"Value 1.0 must not be covered");
        instance = new PaletteEntryForValue(Float.NaN, c0);
        Assertions.assertTrue((boolean)instance.isCovered(Float.NaN), (String)"NaN value must be covered");
        Assertions.assertFalse((boolean)instance.isCovered(1.0f), (String)"Value 1.0 must not be covered");
    }

    @Test
    public void testGetARGB() {
        Color c0 = new Color(-16776961);
        PaletteEntryForValue instance = new PaletteEntryForValue(0.0f, c0);
        int a0 = instance.getARGB(0.0f);
        int a1 = instance.getARGB(0.5f);
        int a2 = instance.getARGB(Float.NaN);
        Assertions.assertEquals((int)-16776961, (int)a0, (String)"Invalid value for target 0.0f");
        Assertions.assertEquals((int)0, (int)a1, (String)"Invalid value for target 0.5f");
        Assertions.assertEquals((int)0, (int)a2, (String)"Invalid value for target NaN");
        instance = new PaletteEntryForValue(Float.NaN, c0);
        a0 = instance.getARGB(0.0f);
        a1 = instance.getARGB(Float.NaN);
        Assertions.assertEquals((int)0, (int)a0, (String)"Invalid value for target 0.0f");
        Assertions.assertEquals((int)-16776961, (int)a1, (String)"Invalid value for target NaN");
    }

    @Test
    public void testGetColor() {
        Color cTest = new Color(-16776961);
        PaletteEntryForValue instance = new PaletteEntryForValue(0.0f, cTest);
        Color c0 = instance.getColor(0.0f);
        int a0 = c0.getRGB();
        Assertions.assertEquals((int)-16776961, (int)a0, (String)"Invalid value for 0.0f");
        c0 = instance.getColor(1.0f);
        Assertions.assertNull((Object)c0, (String)"Non-null return for invalid target 1.0f");
        c0 = instance.getColor(Float.NaN);
        Assertions.assertNull((Object)c0, (String)"Non-null return for invalid target 1.0f");
        instance = new PaletteEntryForValue(Float.NaN, cTest);
        c0 = instance.getColor(Float.NaN);
        Assertions.assertNotNull((Object)c0, (String)"Invalid return for valid target Float.NaN");
        c0 = instance.getColor(1.0f);
        Assertions.assertNull((Object)c0, (String)"Invalid return for invalid valid target 1.0f");
    }

    @Test
    public void testFaultyConstructors() {
        Color c0 = new Color(-16776961);
        Color c1 = new Color(-16711936);
        try {
            PaletteEntryForValue pTest = new PaletteEntryForValue(0.0f, null);
            Assertions.fail((String)"Constructor failed to detect null color");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

