/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.photometricinterpreters.floatingpoint;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.floatingpoint.PaletteEntry;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.floatingpoint.PaletteEntryForRange;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.floatingpoint.PaletteEntryForValue;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.floatingpoint.PhotometricInterpreterFloat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class PhotometricInterpreterFloatTest {
    private static PhotometricInterpreterFloat pInterp;
    private static PhotometricInterpreterFloat bandedInterp;
    private static ImageBuilder imageBuilder;
    private static ImageBuilder bandedImageBuilder;
    private static final Color orange;
    private static final Color green;

    @BeforeAll
    public static void setUpClass() throws ImageReadException, IOException {
        int i;
        int i2;
        ArrayList<PaletteEntryForRange> paletteList = new ArrayList<PaletteEntryForRange>();
        ArrayList<PaletteEntry> reverseList = new ArrayList<PaletteEntry>();
        for (i2 = 0; i2 < 256; i2 += 32) {
            int i1 = i2 + 31;
            float f0 = (float)i2 / 256.0f;
            float f1 = (float)(i2 + 32) / 256.0f;
            int argb0 = 0xFF000000 | i2 << 8 | i2;
            int argb1 = 0xFF000000 | i1 << 8 | i2;
            Color c0 = new Color(argb0);
            Color c1 = new Color(argb1);
            PaletteEntryForRange entry = new PaletteEntryForRange(f0, f1, c0, c1);
            paletteList.add(entry);
        }
        for (i2 = paletteList.size() - 1; i2 >= 0; --i2) {
            PaletteEntry entry = (PaletteEntry)paletteList.get(i2);
            reverseList.add(entry);
        }
        pInterp = new PhotometricInterpreterFloat(reverseList);
        imageBuilder = new ImageBuilder(257, 257, false);
        int[] samples = new int[1];
        for (int i3 = 0; i3 <= 256; ++i3) {
            float f = (float)i3 / 256.0f;
            samples[0] = Float.floatToRawIntBits(f);
            pInterp.interpretPixel(imageBuilder, samples, i3, i3);
        }
        ArrayList<Object> bandedPaletteList = new ArrayList<Object>();
        bandedPaletteList.add(new PaletteEntryForRange(0.0f, 0.33f, green));
        bandedPaletteList.add(new PaletteEntryForRange(0.33f, 0.66f, Color.white));
        bandedPaletteList.add(new PaletteEntryForRange(0.66f, 1.0f, orange));
        bandedPaletteList.add(new PaletteEntryForValue(Float.NaN, Color.gray));
        bandedPaletteList.add(new PaletteEntryForValue(-1.0f, Color.gray));
        bandedInterp = new PhotometricInterpreterFloat(bandedPaletteList);
        bandedImageBuilder = new ImageBuilder(300, 200, false);
        for (int j = 0; j < 300; ++j) {
            float f = (float)j / 299.0f;
            samples[0] = Float.floatToRawIntBits(f);
            for (int i4 = 0; i4 < 200; ++i4) {
                bandedInterp.interpretPixel(bandedImageBuilder, samples, j, i4);
            }
        }
        samples[0] = Float.floatToRawIntBits(Float.NaN);
        for (i = 0; i < 200; ++i) {
            bandedInterp.interpretPixel(bandedImageBuilder, samples, 0, i);
            bandedInterp.interpretPixel(bandedImageBuilder, samples, 299, i);
        }
        samples[0] = Float.floatToRawIntBits(-1.0f);
        for (i = 0; i < 300; ++i) {
            bandedInterp.interpretPixel(bandedImageBuilder, samples, i, 0);
            bandedInterp.interpretPixel(bandedImageBuilder, samples, i, 199);
        }
    }

    @Test
    public void testInterpretPixel() {
        for (int i = 0; i < 256; ++i) {
            int lowTest = i / 32 * 32;
            int argb = imageBuilder.getRGB(i, i);
            int b = argb & 0xFF;
            Assertions.assertEquals((int)b, (int)lowTest, (String)("Invalid conversion for level " + i));
        }
        int argb = imageBuilder.getRGB(256, 256);
        Assertions.assertEquals((int)argb, (int)0, (String)"Invalid upper-bound test");
        argb = bandedImageBuilder.getRGB(0, 0);
        Assertions.assertEquals((int)Color.gray.getRGB(), (int)argb, (String)"Invalid mapping of NaN");
        argb = bandedImageBuilder.getRGB(50, 10);
        Assertions.assertEquals((int)green.getRGB(), (int)argb, (String)"Invalid mapping of green range");
        argb = bandedImageBuilder.getRGB(150, 10);
        Assertions.assertEquals((int)Color.white.getRGB(), (int)argb, (String)"Invalid mapping of white range");
        argb = bandedImageBuilder.getRGB(250, 10);
        Assertions.assertEquals((int)orange.getRGB(), (int)argb, (String)"Invalid mapping of orange range");
    }

    @Test
    public void testGetMinFound() {
        float expResult = 0.0f;
        float result = pInterp.getMinFound();
        Assertions.assertEquals((double)0.0, (double)result, (double)0.0, (String)"Invalid minimum value");
    }

    @Test
    public void testGetMaxXY() {
        int[] expResult = new int[]{256, 256};
        int[] result = pInterp.getMaxXY();
        Assertions.assertArrayEquals((int[])expResult, (int[])result);
    }

    @Test
    public void testGetMaxFound() {
        float expResult = 1.0f;
        float result = pInterp.getMinFound();
        Assertions.assertEquals((double)1.0, (double)result, (double)1.0, (String)"Invalid maximum value");
    }

    @Test
    public void testGetMinXY() {
        int[] expResult = new int[]{0, 0};
        int[] result = pInterp.getMinXY();
        Assertions.assertArrayEquals((int[])expResult, (int[])result);
    }

    @Test
    public void testGetMeanFound() {
        float expResult = 0.5f;
        float result = pInterp.getMinFound();
        Assertions.assertEquals((double)0.5, (double)result, (double)1.0, (String)"Invalid mean value");
    }

    @Test
    public void testMapValueToARGB() {
        int argb = pInterp.mapValueToARGB(0.5f);
        int test = imageBuilder.getRGB(128, 128);
        Assertions.assertEquals((int)test, (int)argb, (String)"Conflicting results from value-to-ARGB map");
        argb = pInterp.mapValueToARGB(Float.NaN);
        Assertions.assertEquals((int)0, (int)argb, (String)"Non-defined NaN did not return ARGB of zero");
        argb = bandedInterp.mapValueToARGB(Float.NaN);
        test = Color.gray.getRGB();
        Assertions.assertEquals((int)test, (int)argb, (String)"Float.NaN mapped to incorrect ARGB");
        argb = bandedInterp.mapValueToARGB(-1.0f);
        test = Color.gray.getRGB();
        Assertions.assertEquals((int)test, (int)argb, (String)"Excluded value mapped to incorrect ARGB");
    }

    @Test
    public void testConstructors() {
        PhotometricInterpreterFloat ptest = new PhotometricInterpreterFloat(0.0f, 1.0f);
        ptest = new PhotometricInterpreterFloat(1.0f, 0.0f);
        try {
            ptest = new PhotometricInterpreterFloat(null);
            Assertions.fail((String)"Constructor failed to detect null arguments");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ptest = new PhotometricInterpreterFloat(0.1f, 0.1f);
            Assertions.fail((String)"Constructor failed to detect bad-range argument values");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testOverlappingEntriesEntry() throws ImageReadException, IOException {
        Color c0 = new Color(-16776961);
        Color c1 = new Color(-16711936);
        ArrayList<PaletteEntryForRange> overlapList = new ArrayList<PaletteEntryForRange>();
        overlapList.add(new PaletteEntryForRange(0.0f, 1.0f, c0));
        overlapList.add(new PaletteEntryForRange(0.0f, 1.5f, c1));
        PhotometricInterpreterFloat interpreter = new PhotometricInterpreterFloat(overlapList);
        imageBuilder = new ImageBuilder(257, 257, false);
        int[] samples = new int[]{Float.floatToRawIntBits(0.5f)};
        interpreter.interpretPixel(imageBuilder, samples, 0, 0);
        samples[0] = Float.floatToRawIntBits(1.2f);
        interpreter.interpretPixel(imageBuilder, samples, 1, 1);
        int argb0 = imageBuilder.getRGB(0, 0) | 0xFF000000;
        int argb1 = imageBuilder.getRGB(1, 1) | 0xFF000000;
        Assertions.assertEquals((int)argb0, (int)c0.getRGB(), (String)"Invalid result for overlapping palette entry 0");
        Assertions.assertEquals((int)argb1, (int)c1.getRGB(), (String)"Invalid result for overlapping palette entry 1");
        argb0 = interpreter.mapValueToARGB(0.5f);
        argb1 = interpreter.mapValueToARGB(1.2f);
        Assertions.assertEquals((int)argb0, (int)c0.getRGB(), (String)"Invalid mapping for overlapping palette entry 0");
        Assertions.assertEquals((int)argb1, (int)c1.getRGB(), (String)"Invalid mapping for overlapping palette entry 1");
    }

    static {
        orange = new Color(255, 136, 62);
        green = new Color(22, 155, 98);
    }
}

