/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.write;

import org.apache.commons.imaging.formats.tiff.constants.TiffConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputField;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TiffOutputDirectoryTest {
    private TiffOutputDirectory directory;

    @BeforeEach
    public void setUp() {
        this.directory = new TiffOutputDirectory(0, TiffConstants.DEFAULT_TIFF_BYTE_ORDER);
    }

    @Test
    public void testFindField() throws Exception {
        this.directory.add(TiffTagConstants.TIFF_TAG_DOCUMENT_NAME, new String[]{"Test.tiff"});
        TiffOutputField field = this.directory.findField((TagInfo)TiffTagConstants.TIFF_TAG_DOCUMENT_NAME);
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)TiffTagConstants.TIFF_TAG_DOCUMENT_NAME, (Object)field.tagInfo);
        byte[] documentNameAsBytes = TiffTagConstants.TIFF_TAG_DOCUMENT_NAME.encodeValue(TiffConstants.DEFAULT_TIFF_BYTE_ORDER, new String[]{"Test.tiff"});
        Assertions.assertTrue((boolean)field.bytesEqual(documentNameAsBytes));
    }
}

