/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.xmp;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageParser;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingParameters;
import org.apache.commons.imaging.ImagingTest;
import org.apache.commons.imaging.common.XmpImagingParameters;
import org.apache.commons.imaging.internal.Debug;
import org.apache.commons.imaging.internal.Util;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XmpUpdateTest
extends ImagingTest {
    @Test
    public void test() throws Exception {
        List<File> images = XmpUpdateTest.getTestImages();
        for (File imageFile : images) {
            if (imageFile.getName().toLowerCase().endsWith(".png") && this.isInvalidPNGTestFile(imageFile)) continue;
            Debug.debug((String)"imageFile", (Object)imageFile);
            Debug.debug();
            ImageFormat imageFormat = Imaging.guessFormat((File)imageFile);
            if (!imageFormat.equals(ImageFormats.PNG) || !imageFormat.equals(ImageFormats.TIFF) || !imageFormat.equals(ImageFormats.GIF)) continue;
            String xmpXml = Imaging.getXmpXml((File)imageFile);
            if (null == xmpXml && imageFormat.equals(ImageFormats.GIF)) {
                xmpXml = "temporary test until I can locate a GIF with XMP in the wild.";
            }
            if (null == xmpXml) continue;
            File tempFile = File.createTempFile(imageFile.getName() + ".", "." + imageFormat.getDefaultExtension());
            BufferedImage image = Imaging.getBufferedImage((File)imageFile);
            ImageParser parser = Util.getImageParser((String)("." + imageFormat.getDefaultExtension()));
            ImagingParameters params = parser.getDefaultParameters();
            ((XmpImagingParameters)params).setXmpXml(xmpXml);
            try (FileOutputStream fos = new FileOutputStream(tempFile);){
                parser.writeImage(image, (OutputStream)fos, params);
            }
            String xmpXmlOut = Imaging.getXmpXml((File)tempFile);
            Assertions.assertNotNull((Object)xmpXmlOut);
            Assertions.assertEquals((Object)xmpXmlOut, (Object)xmpXml);
        }
    }
}

