/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.palette;

import java.awt.image.BufferedImage;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.ImagingTest;
import org.apache.commons.imaging.palette.Dithering;
import org.apache.commons.imaging.palette.MedianCut;
import org.apache.commons.imaging.palette.MedianCutQuantizer;
import org.apache.commons.imaging.palette.MostPopulatedBoxesMedianCut;
import org.apache.commons.imaging.palette.Palette;
import org.apache.commons.imaging.palette.PaletteFactory;
import org.apache.commons.imaging.palette.SimplePalette;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PaletteQuantizationTest
extends ImagingTest {
    @Test
    public void testPaletteQuantization() throws ImageWriteException {
        BufferedImage whiteImage = new BufferedImage(10, 10, 1);
        for (int y = 0; y < whiteImage.getHeight(); ++y) {
            for (int x = 0; x < whiteImage.getWidth(); ++x) {
                whiteImage.setRGB(x, y, 0xFFFFFF);
            }
        }
        this.checkPaletteDetails(whiteImage, 10, 1);
        BufferedImage whiteAndBlackImage = new BufferedImage(10, 10, 1);
        for (int y = 0; y < whiteImage.getHeight(); ++y) {
            int x;
            for (x = 0; x < 5; ++x) {
                whiteAndBlackImage.setRGB(x, y, 0xFFFFFF);
            }
            for (x = 5; x < 10; ++x) {
                whiteAndBlackImage.setRGB(x, y, 0);
            }
        }
        this.checkPaletteDetails(whiteAndBlackImage, 10, 2);
        BufferedImage rainbowImage = new BufferedImage(9, 10, 1);
        for (int y = 0; y < whiteImage.getHeight(); ++y) {
            int x;
            for (x = 0; x < 3; ++x) {
                rainbowImage.setRGB(x, y, 0xFF0000);
            }
            for (x = 3; x < 6; ++x) {
                rainbowImage.setRGB(x, y, 65280);
            }
            for (x = 6; x < 9; ++x) {
                rainbowImage.setRGB(x, y, 255);
            }
        }
        this.checkPaletteDetails(rainbowImage, 10, 3);
        this.checkPaletteDetails(rainbowImage, 2, 2);
    }

    private void checkPaletteDetails(BufferedImage image, int limit, int expectedSize) throws ImageWriteException {
        PaletteFactory paletteFactory = new PaletteFactory();
        SimplePalette palette = paletteFactory.makeExactRgbPaletteSimple(image, limit);
        boolean exact = false;
        if (palette != null) {
            Assertions.assertEquals((int)expectedSize, (int)palette.length());
            exact = true;
        }
        if (exact) {
            // empty if block
        }
        palette = paletteFactory.makeQuantizedRgbaPalette(image, false, limit);
        Assertions.assertEquals((int)expectedSize, (int)palette.length());
        this.checkUniqueColors(image, (Palette)palette);
        if (exact) {
            this.checkPixelsAreIdentical(image, (Palette)palette);
        }
        palette = paletteFactory.makeQuantizedRgbPalette(image, limit);
        Assertions.assertEquals((int)expectedSize, (int)palette.length());
        if (exact) {
            // empty if block
        }
        MedianCutQuantizer medianCutQuantizer = new MedianCutQuantizer(true);
        palette = medianCutQuantizer.process(image, limit, (MedianCut)new MostPopulatedBoxesMedianCut());
        Assertions.assertEquals((int)expectedSize, (int)palette.length());
        this.checkUniqueColors(image, (Palette)palette);
        if (exact) {
            this.checkPixelsAreIdentical(image, (Palette)palette);
        }
    }

    private void checkUniqueColors(BufferedImage src, Palette palette) throws ImageWriteException {
        BufferedImage dst = new BufferedImage(src.getWidth(), src.getHeight(), 1);
        dst.getGraphics().drawImage(src, 0, 0, src.getWidth(), src.getHeight(), null);
        Dithering.applyFloydSteinbergDithering((BufferedImage)dst, (Palette)palette);
        SimplePalette ditheredPalette = new PaletteFactory().makeExactRgbPaletteSimple(dst, palette.length() * 2);
        Assertions.assertEquals((int)palette.length(), (int)ditheredPalette.length());
    }

    private void checkPixelsAreIdentical(BufferedImage src, Palette palette) throws ImageWriteException {
        BufferedImage dst = new BufferedImage(src.getWidth(), src.getHeight(), 1);
        dst.getGraphics().drawImage(src, 0, 0, src.getWidth(), src.getHeight(), null);
        Dithering.applyFloydSteinbergDithering((BufferedImage)dst, (Palette)palette);
        for (int y = 0; y < src.getHeight(); ++y) {
            for (int x = 0; x < src.getWidth(); ++x) {
                Assertions.assertEquals((int)src.getRGB(x, y), (int)dst.getRGB(x, y));
            }
        }
    }
}

