/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.roundtrip;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import org.apache.commons.imaging.internal.Debug;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;

final class ImageAsserts {
    private ImageAsserts() {
    }

    static void assertEquals(BufferedImage a, BufferedImage b) {
        ImageAsserts.assertEquals(a, b, 0);
    }

    static void assertEquals(BufferedImage a, BufferedImage b, int tolerance) {
        Assertions.assertEquals((int)a.getWidth(), (int)b.getWidth());
        Assertions.assertEquals((int)a.getHeight(), (int)b.getHeight());
        for (int x = 0; x < a.getWidth(); ++x) {
            for (int y = 0; y < a.getHeight(); ++y) {
                int b_argb;
                int a_argb = a.getRGB(x, y);
                if (a_argb != (b_argb = b.getRGB(x, y)) && ImageAsserts.calculateARGBDistance(a_argb, b_argb) <= tolerance) continue;
                if (a_argb != b_argb) {
                    Debug.debug((String)("width: " + a.getWidth()));
                    Debug.debug((String)("height: " + a.getHeight()));
                    Debug.debug((String)("distance: " + ImageAsserts.calculateARGBDistance(a_argb, b_argb)));
                    Debug.debug((String)("x: " + x));
                    Debug.debug((String)("y: " + y));
                    Debug.debug((String)("a_argb: " + a_argb + " (0x" + Integer.toHexString(a_argb) + ")"));
                    Debug.debug((String)("b_argb: " + b_argb + " (0x" + Integer.toHexString(b_argb) + ")"));
                }
                Assertions.assertEquals((int)a_argb, (int)b_argb);
            }
        }
    }

    static int calculateARGBDistance(int a, int b) {
        int aAlpha = 0xFF & a >> 24;
        int aRed = 0xFF & a >> 16;
        int aGreen = 0xFF & a >> 8;
        int aBlue = 0xFF & a >> 0;
        int bAlpha = 0xFF & b >> 24;
        int bRed = 0xFF & b >> 16;
        int bGreen = 0xFF & b >> 8;
        int bBlue = 0xFF & b >> 0;
        return Math.abs(aAlpha - bAlpha) + Math.abs(aRed - bRed) + Math.abs(aGreen - bGreen) + Math.abs(aBlue - bBlue);
    }

    static void assertEquals(File a, File b) throws IOException {
        Assertions.assertTrue((a.exists() && a.isFile() ? 1 : 0) != 0);
        Assertions.assertTrue((b.exists() && b.isFile() ? 1 : 0) != 0);
        Assertions.assertEquals((long)a.length(), (long)b.length());
        byte[] aData = FileUtils.readFileToByteArray((File)a);
        byte[] bData = FileUtils.readFileToByteArray((File)b);
        int i = 0;
        while ((long)i < a.length()) {
            int aByte = 0xFF & aData[i];
            int bByte = 0xFF & bData[i];
            if (aByte != bByte) {
                Debug.debug((String)("a: " + a));
                Debug.debug((String)("b: " + b));
                Debug.debug((String)("i: " + i));
                Debug.debug((String)("aByte: " + aByte + " (0x" + Integer.toHexString(aByte) + ")"));
                Debug.debug((String)("bByte: " + bByte + " (0x" + Integer.toHexString(bByte) + ")"));
            }
            Assertions.assertEquals((int)aByte, (int)bByte);
            ++i;
        }
    }
}

