/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.roundtrip;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.stream.Stream;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.roundtrip.FormatInfo;
import org.apache.commons.imaging.roundtrip.RoundtripBase;
import org.apache.commons.imaging.roundtrip.TestImages;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class NullParametersRoundtripTest
extends RoundtripBase {
    public static Stream<FormatInfo> data() {
        return Stream.of(FormatInfo.READ_WRITE_FORMATS);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testNullParametersRoundtrip(FormatInfo formatInfo) throws Exception {
        BufferedImage testImage = TestImages.createFullColorImage(1, 1);
        File temp1 = File.createTempFile("nullParameters.", "." + formatInfo.format.getDefaultExtension());
        Imaging.writeImage((BufferedImage)testImage, (File)temp1, (ImageFormat)formatInfo.format);
        Imaging.getImageInfo((File)temp1);
        Imaging.getImageSize((File)temp1);
        Imaging.getMetadata((File)temp1);
        Imaging.getICCProfile((File)temp1);
        BufferedImage imageRead = Imaging.getBufferedImage((File)temp1);
        Assertions.assertNotNull((Object)imageRead);
    }
}

