/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.roundtrip;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.stream.Stream;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageParser;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.ImagingParameters;
import org.apache.commons.imaging.common.BufferedImageFactory;
import org.apache.commons.imaging.common.RgbBufferedImageFactory;
import org.apache.commons.imaging.internal.Debug;
import org.apache.commons.imaging.internal.Util;
import org.apache.commons.imaging.roundtrip.FormatInfo;
import org.apache.commons.imaging.roundtrip.ImageAsserts;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.provider.Arguments;

public class RoundtripBase {
    protected void roundtrip(FormatInfo formatInfo, BufferedImage testImage, String tempPrefix, boolean imageExact) throws IOException, ImageReadException, ImageWriteException {
        File temp1 = File.createTempFile(tempPrefix + ".", "." + formatInfo.format.getDefaultExtension());
        Debug.debug((String)("tempFile: " + temp1.getName()));
        ImageParser imageParser = Util.getImageParser((ImageFormat)formatInfo.format);
        ImagingParameters params = Util.getImageParser((ImageFormat)formatInfo.format).getDefaultParameters();
        try (FileOutputStream fos = new FileOutputStream(temp1);){
            imageParser.writeImage(testImage, (OutputStream)fos, params);
        }
        ImagingParameters readParams = Util.getImageParser((ImageFormat)formatInfo.format).getDefaultParameters();
        readParams.setBufferedImageFactory((BufferedImageFactory)new RgbBufferedImageFactory());
        BufferedImage image2 = imageParser.getBufferedImage(temp1, readParams);
        Assertions.assertNotNull((Object)image2);
        if (imageExact) {
            ImageAsserts.assertEquals(testImage, image2);
        }
        if (formatInfo.identicalSecondWrite) {
            File temp2 = File.createTempFile(tempPrefix + ".", "." + formatInfo.format.getDefaultExtension());
            try (FileOutputStream fos = new FileOutputStream(temp2);){
                imageParser.writeImage(image2, (OutputStream)fos, params);
            }
            ImageAsserts.assertEquals(temp1, temp2);
        }
    }

    public static Stream<Arguments> createRoundtripArguments(BufferedImage[] images) {
        return Stream.of(images).flatMap(i -> Stream.of(FormatInfo.READ_WRITE_FORMATS).map(f -> Arguments.of((Object[])new Object[]{i, f})));
    }
}

