/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.roundtrip;

import java.awt.image.BufferedImage;

final class TestImages {
    private TestImages() {
    }

    static BufferedImage createArgbBitmapImage(int width, int height) {
        BufferedImage result = new BufferedImage(width, height, 2);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int modulator = y + 2;
                int argb = (x + y) % modulator == 0 ? -16777216 : -1;
                result.setRGB(x, y, argb);
            }
        }
        return result;
    }

    static BufferedImage createBitmapBitmapImage(int width, int height) {
        BufferedImage result = new BufferedImage(width, height, 12);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int modulator = y + 2;
                int argb = (x + y) % modulator == 0 ? -16777216 : -1;
                result.setRGB(x, y, argb);
            }
        }
        return result;
    }

    static BufferedImage createArgbGrayscaleImage(int width, int height) {
        BufferedImage result = new BufferedImage(width, height, 2);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int value = 256 * (x + y) / (width + height);
                int argb = 0xFF000000 | value << 16 | value << 8 | value << 0;
                result.setRGB(x, y, argb);
            }
        }
        return result;
    }

    static BufferedImage createGrayscaleGrayscaleImage(int width, int height) {
        BufferedImage result = new BufferedImage(width, height, 10);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int value = 256 * (x + y) / (width + height);
                int argb = 0xFF000000 | value << 16 | value << 8 | value << 0;
                result.setRGB(x, y, argb);
            }
        }
        return result;
    }

    static BufferedImage createLimitedColorImage(int width, int height) {
        int[] colors = new int[]{-1, -16777216, -1048576, -16776961, -15584170, -65793, -8420993};
        BufferedImage result = new BufferedImage(width, height, 2);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int argb = colors[(x + y) % colors.length];
                result.setRGB(x, y, argb);
            }
        }
        return result;
    }

    static BufferedImage createFullColorImage(int width, int height) {
        BufferedImage result = new BufferedImage(width, height, 2);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int red = x * 255 / width;
                int green = y * 255 / height;
                int blue = (x + y) * 255 / (width + height);
                int argb = 0xFF000000 | red << 16 | green << 8 | blue << 0;
                result.setRGB(x, y, argb);
            }
        }
        return result;
    }
}

