/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.test.util;

import java.io.File;
import org.apache.commons.imaging.internal.Debug;

public class FileSystemTraversal {
    public static final int MODE_FILES = 1;
    public static final int MODE_FOLDERS = 2;
    public static final int MODE_FILES_AND_FOLDERS = 3;
    public static final int MODE_ALL = 4;
    private static boolean ON_MAC_OS_X;

    public boolean traverseFiles(File file, Visitor visitor) {
        return this.traverse(file, 1, visitor);
    }

    public boolean traverseFolders(File file, Visitor visitor) {
        return this.traverse(file, 2, visitor);
    }

    public boolean traverseAll(File file, Visitor visitor) {
        return this.traverse(file, 3, visitor);
    }

    public boolean traverse(File file, int mode, Visitor visitor) {
        return this.traverse(file, mode, visitor, 0.0, 1.0);
    }

    private boolean traverse(File file, int mode, Visitor visitor, double estimate, double estimateIncrement) {
        if (file.isFile()) {
            if (!(mode != 1 && mode != 3 && mode != 4 || visitor.visit(file, estimate))) {
                return false;
            }
        } else if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    String name;
                    File child = files[i];
                    if (ON_MAC_OS_X && child.isDirectory() && ((name = child.getName()).equalsIgnoreCase("automount") || name.equalsIgnoreCase("private") || name.equalsIgnoreCase("Network") || name.equalsIgnoreCase("Volumes")) || this.traverse(child, mode, visitor, estimate + estimateIncrement * (double)i / (double)files.length, estimateIncrement / (double)files.length)) continue;
                    return false;
                }
            }
            if (!(mode != 2 && mode != 3 && mode != 4 || visitor.visit(file, estimate))) {
                return false;
            }
        } else if (mode == 4 && !visitor.visit(file, estimate)) {
            return false;
        }
        return true;
    }

    public boolean traverseFiles(Visitor visitor) {
        return this.traverse(1, visitor);
    }

    public boolean traverseFolders(Visitor visitor) {
        return this.traverse(2, visitor);
    }

    public boolean traverseAll(Visitor visitor) {
        return this.traverse(3, visitor);
    }

    public boolean traverse(int mode, Visitor visitor) {
        return this.traverse(mode, visitor, 0.0, 1.0);
    }

    private boolean traverse(int mode, Visitor visitor, double estimate, double estimateIncrement) {
        File[] roots = File.listRoots();
        if (ON_MAC_OS_X) {
            File Volumes = new File("/Volumes/");
            roots = Volumes.listFiles();
        } else {
            roots = File.listRoots();
        }
        if (roots == null) {
            return false;
        }
        for (int i = 0; i < roots.length; ++i) {
            File root = roots[i];
            if (root == null || !root.exists() || this.traverse(roots[i], mode, visitor, estimate + estimateIncrement * (double)i / (double)roots.length, estimateIncrement / (double)roots.length)) continue;
            return false;
        }
        return true;
    }

    static {
        try {
            ON_MAC_OS_X = System.getProperty("mrj.version") != null;
        }
        catch (Exception e) {
            Debug.debug((Throwable)e);
            ON_MAC_OS_X = false;
        }
    }

    public static interface Visitor {
        public boolean visit(File var1, double var2);
    }
}

