/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LazyDefaultSchemaCreationTest
extends BaseJDBCTestCase {
    private static final String LOCK_TIMEOUT = "40XL1";

    public LazyDefaultSchemaCreationTest(String name) {
        super(name);
    }

    public void testDerby48testNewSchemaHang() throws SQLException {
        Connection c1 = this.openUserConnection("newuser");
        c1.setAutoCommit(false);
        Statement s1 = c1.createStatement();
        s1.executeUpdate("create table t1(i int)");
        s1.close();
        Connection c2 = null;
        try {
            c2 = this.openUserConnection("newuser");
        }
        catch (SQLException e) {
            if (e.getSQLState().equals(LOCK_TIMEOUT)) {
                c1.rollback();
                c1.close();
                LazyDefaultSchemaCreationTest.fail("DERBY-48 still seen", e);
            }
            throw e;
        }
        c1.rollback();
        JDBC.assertSingleValueResultSet(c1.createStatement().executeQuery("select schemaname from sys.sysschemas where schemaname='NEWUSER'"), "NEWUSER");
        c1.rollback();
        c1.close();
        c2.close();
    }

    public void testDerby48SelfLockingRecovery() throws SQLException {
        Connection c1 = this.openUserConnection("newuser");
        c1.setAutoCommit(false);
        c1.setTransactionIsolation(8);
        Statement s1 = c1.createStatement();
        s1.executeQuery("select count(*) from sys.sysschemas");
        s1.executeUpdate("create table t1(i int)");
        JDBC.assertSingleValueResultSet(s1.executeQuery("select schemaname from sys.sysschemas where schemaname='NEWUSER'"), "NEWUSER");
        c1.rollback();
        JDBC.assertEmpty(s1.executeQuery("select * from sys.sysschemas where schemaname='NEWUSER'"));
        c1.rollback();
    }

    public void testDerby48SelfLockingRecoveryDeadlockDetectionOn() throws SQLException {
        Connection c1 = this.openUserConnection("newuser");
        c1.setAutoCommit(false);
        c1.setTransactionIsolation(8);
        Statement s1 = c1.createStatement();
        s1.executeQuery("select count(*) from sys.sysschemas");
        try {
            s1.executeUpdate("create table t1(i int)");
            LazyDefaultSchemaCreationTest.fail((String)"Expected exception 40XL1");
        }
        catch (SQLException e) {
            LazyDefaultSchemaCreationTest.assertSQLState("Expected state: ", LOCK_TIMEOUT, e);
        }
        JDBC.assertEmpty(s1.executeQuery("select * from sys.sysschemas where schemaname='NEWUSER'"));
        c1.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDerby3678() throws SQLException {
        Connection c1 = this.openUserConnection("newuser");
        Connection c2 = null;
        c1.setAutoCommit(false);
        Statement s1 = c1.createStatement();
        s1.executeUpdate("create schema newuser");
        s1.executeUpdate("create table t(i int)");
        try {
            c2 = this.openUserConnection("newuser");
            LazyDefaultSchemaCreationTest.fail((String)"Expected exception 40XL1");
        }
        catch (SQLException e) {
            LazyDefaultSchemaCreationTest.assertSQLState("Expected state: ", LOCK_TIMEOUT, e);
        }
        finally {
            c1.rollback();
        }
    }

    public void testOtherImplicitSchemaCreation() throws SQLException {
        Connection c1 = this.openUserConnection("newuser");
        c1.setAutoCommit(false);
        Statement s1 = c1.createStatement();
        s1.executeUpdate("create table otherschema.t1(i int)");
        s1.close();
        JDBC.assertSingleValueResultSet(c1.createStatement().executeQuery("select schemaname from sys.sysschemas where schemaname='OTHERSCHEMA'"), "OTHERSCHEMA");
        c1.rollback();
        JDBC.assertEmpty(c1.createStatement().executeQuery("select schemaname from sys.sysschemas where schemaname='OTHERSCHEMA'"));
        c1.rollback();
        c1.close();
    }

    public void testDerby3043CheckConstraint() throws SQLException {
        Connection c0 = this.openUserConnection("frogs");
        Statement s0 = c0.createStatement();
        JDBC.assertEmpty(s0.executeQuery("select * from sys.sysschemas where schemaname='FROGS'"));
        JDBC.assertEmpty(s0.executeQuery("select * from sys.sysschemas where schemaname='NOSUCH'"));
        s0.executeUpdate("create table frogs.users2(username varchar(16) CHECK(LENGTH(username)>7))");
        s0.executeUpdate("create table nosuch.users(username varchar(16) CHECK(LENGTH(username)>7))");
        JDBC.assertSingleValueResultSet(s0.executeQuery("select schemaname from sys.sysschemas where schemaname='FROGS'"), "FROGS");
        JDBC.assertSingleValueResultSet(s0.executeQuery("select schemaname from sys.sysschemas where schemaname='NOSUCH'"), "NOSUCH");
        c0.close();
        Connection c1 = this.openUserConnection("blogs");
        Statement s1 = c1.createStatement();
        JDBC.assertEmpty(s1.executeQuery("select * from sys.sysschemas where schemaname='BLOGS'"));
        s1.executeUpdate("create table users(username varchar(16) CHECK(LENGTH(username)>7))");
        s1.executeUpdate("CREATE TABLE BLOGSCOM__BLOGS__USERS(PK INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY,username VARCHAR(16) NOT NULL   CONSTRAINT BLOGSCOM__BLOGS__USERS_UNIQUE_username UNIQUE   CONSTRAINT BLOGSCOM__BLOGS__USERS_PASSWORD_username     CHECK(LENGTH(username)>7),password VARCHAR (32672) NOT NULL , PRIMARY KEY(PK))");
        JDBC.assertSingleValueResultSet(s1.executeQuery("select schemaname from sys.sysschemas where schemaname='BLOGS'"), "BLOGS");
        c1.close();
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.createStatement().executeUpdate("drop schema newuser restrict");
        }
        catch (SQLException e) {
            LazyDefaultSchemaCreationTest.assertSQLState("Expected state: ", "42Y07", e);
        }
        super.tearDown();
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("LazyDefaultSchemaCreationTest");
        BaseTestSuite[] suites = new BaseTestSuite[]{new BaseTestSuite("LazyDefaultSchemaCreationTest:embedded"), new BaseTestSuite("LazyDefaultSchemaCreationTest:clientServer")};
        for (int i = 0; i < 2; ++i) {
            suites[i].addTest(DatabasePropertyTestSetup.setLockTimeouts((Test)new LazyDefaultSchemaCreationTest("testDerby48testNewSchemaHang"), 2, 1));
            suites[i].addTest(DatabasePropertyTestSetup.setLockTimeouts((Test)new LazyDefaultSchemaCreationTest("testDerby48SelfLockingRecovery"), 2, 1));
            Properties p = new Properties();
            p.setProperty("derby.locks.deadlockTrace", "true");
            suites[i].addTest(DatabasePropertyTestSetup.setLockTimeouts((Test)new DatabasePropertyTestSetup((Test)new LazyDefaultSchemaCreationTest("testDerby48SelfLockingRecoveryDeadlockDetectionOn"), p, false), 2, 1));
            suites[i].addTest(DatabasePropertyTestSetup.setLockTimeouts((Test)new DatabasePropertyTestSetup((Test)new LazyDefaultSchemaCreationTest("testDerby3678"), p, false), 2, 1));
            suites[i].addTest((Test)new CleanDatabaseTestSetup((Test)new LazyDefaultSchemaCreationTest("testDerby3043CheckConstraint")));
            if (i == 0) {
                suite.addTest((Test)suites[i]);
                continue;
            }
            suite.addTest(TestConfiguration.clientServerDecorator((Test)suites[i]));
        }
        return suite;
    }
}

