/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.CurrentState;
import org.apache.helix.task.Task;
import org.apache.helix.task.TaskPartitionState;
import org.apache.helix.task.TaskResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRunner
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TaskRunner.class);
    private final HelixManager _manager;
    private final String _taskName;
    private final String _taskPartition;
    private final String _sessionId;
    private final String _instance;
    private final Object _startedSync = new Object();
    private final Object _doneSync = new Object();
    private final Task _task;
    private volatile TaskResult _result = null;
    private volatile boolean _started = false;
    private volatile boolean _timeout = false;
    private volatile boolean _done = false;

    public TaskRunner(Task task, String taskName, String taskPartition, String instance, HelixManager manager, String sessionId) {
        this._task = task;
        this._taskName = taskName;
        this._taskPartition = taskPartition;
        this._instance = instance;
        this._manager = manager;
        this._sessionId = sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            this.signalStarted();
            try {
                this._result = this._task.run();
            }
            catch (ThreadDeath death) {
                throw death;
            }
            catch (Throwable t) {
                LOG.error("Problem running the task, report task as FAILED.", t);
                this._result = new TaskResult(TaskResult.Status.FAILED, "Exception happened in running task: " + t.getMessage());
            }
            switch (this._result.getStatus()) {
                case COMPLETED: {
                    this.requestStateTransition(TaskPartitionState.COMPLETED);
                    return;
                }
                case CANCELED: {
                    if (!this._timeout) return;
                    this.requestStateTransition(TaskPartitionState.TIMED_OUT);
                    return;
                }
                case ERROR: {
                    this.requestStateTransition(TaskPartitionState.TASK_ERROR);
                    return;
                }
                case FAILED: {
                    this.requestStateTransition(TaskPartitionState.TASK_ERROR);
                    return;
                }
                case FATAL_FAILED: {
                    this.requestStateTransition(TaskPartitionState.TASK_ABORTED);
                    return;
                }
                default: {
                    throw new AssertionError((Object)("Unknown task result type: " + this._result.getStatus().name()));
                }
            }
        }
        catch (Exception e) {
            LOG.error("Problem running the task, report task as FAILED.", (Throwable)e);
            this._result = new TaskResult(TaskResult.Status.FAILED, "Exception happened in running task: " + e.getMessage());
            this.requestStateTransition(TaskPartitionState.TASK_ERROR);
            return;
        }
        finally {
            Object object = this._doneSync;
            synchronized (object) {
                this._done = true;
                this._doneSync.notifyAll();
            }
        }
    }

    public void timeout() {
        if (!this._done) {
            this._timeout = true;
            this.cancel();
        }
    }

    public void cancel() {
        if (!this._done) {
            this._task.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTillStarted() {
        Object object = this._startedSync;
        synchronized (object) {
            while (!this._started) {
                try {
                    this._startedSync.wait();
                }
                catch (InterruptedException e) {
                    LOG.warn(String.format("Interrupted while waiting for task %s to start.", this._taskPartition), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskResult waitTillDone() {
        Object object = this._doneSync;
        synchronized (object) {
            while (!this._done) {
                try {
                    this._doneSync.wait();
                }
                catch (InterruptedException e) {
                    LOG.warn(String.format("Interrupted while waiting for task %s to complete.", this._taskPartition), (Throwable)e);
                }
            }
        }
        return this._result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalStarted() {
        Object object = this._startedSync;
        synchronized (object) {
            this._started = true;
            this._startedSync.notifyAll();
        }
    }

    private void requestStateTransition(TaskPartitionState state) {
        boolean success = TaskRunner.setRequestedState(this._manager.getHelixDataAccessor(), this._instance, this._sessionId, this._taskName, this._taskPartition, state);
        if (!success) {
            LOG.error(String.format("Failed to set the requested state to %s for instance %s, session id %s, task partition %s.", new Object[]{state, this._instance, this._sessionId, this._taskPartition}));
        }
    }

    private static boolean setRequestedState(HelixDataAccessor accessor, String instance, String sessionId, String resource, String partition, TaskPartitionState state) {
        LOG.debug(String.format("Requesting a state transition to %s for partition %s.", new Object[]{state, partition}));
        try {
            PropertyKey.Builder keyBuilder = accessor.keyBuilder();
            PropertyKey key = keyBuilder.currentState(instance, sessionId, resource);
            CurrentState currStateDelta = new CurrentState(resource);
            currStateDelta.setRequestedState(partition, state.name());
            return accessor.updateProperty(key, currStateDelta);
        }
        catch (Exception e) {
            LOG.error(String.format("Error when requesting a state transition to %s for partition %s.", new Object[]{state, partition}), (Throwable)e);
            return false;
        }
    }
}

