/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.Map;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerProperties;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.dataproviders.BaseControllerDataProvider;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.model.LiveInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompatibilityCheckStage
extends AbstractBaseStage {
    private static final Logger LOG = LoggerFactory.getLogger((String)CompatibilityCheckStage.class.getName());

    @Override
    public void process(ClusterEvent event) throws Exception {
        HelixManager manager = (HelixManager)event.getAttribute(AttributeName.helixmanager.name());
        BaseControllerDataProvider cache = (BaseControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        if (manager == null || cache == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires HelixManager | DataCache");
        }
        HelixManagerProperties properties = manager.getProperties();
        Map<String, LiveInstance> liveInstanceMap = cache.getLiveInstances();
        for (LiveInstance liveInstance : liveInstanceMap.values()) {
            String participantVersion = liveInstance.getHelixVersion();
            if (properties.isParticipantCompatible(participantVersion)) continue;
            String errorMsg = "incompatible participant. pipeline will not continue. controller: " + manager.getInstanceName() + ", controllerVersion: " + properties.getVersion() + ", minimumSupportedParticipantVersion: " + properties.getProperty("miminum_supported_version.participant") + ", participant: " + liveInstance.getInstanceName() + ", participantVersion: " + participantVersion;
            LogUtil.logError(LOG, event.getEventId(), errorMsg);
            throw new StageException(errorMsg);
        }
    }
}

