/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.linkis.manager.label.constant;

public class LabelKeyConstant {

  public static final String ENGINE_TYPE_KEY = "engineType";

  public static final String EM_INSTANCE_KEY = "emInstance";

  public static final String ENGINE_INSTANCE_KEY = "engineInstance";

  public static final String USER_CREATOR_TYPE_KEY = "userCreator";

  public static final String SERVER_ALIAS_KEY = "serverAlias";

  public static final String YARN_CLUSTER_KEY = "yarnCluster";

  public static final String ENV_TYPE_KEY = "envType";

  public static final String CACHE_KEY = "cache";

  public static final String CODE_TYPE_KEY = "codeType";

  public static final String ENGINE_BASE_INFO_KEY = "engineBaseInfo";

  public static final String CONCURRENT_ENGINE_KEY = "concurrentEngineConn";

  public static final String COMBINED_LABEL_KEY_PREFIX = "combined_";

  public static final String ROUTE_KEY = "route";

  public static final String BIND_ENGINE_KEY = "bindEngine";

  public static final String JOB_QUEUING_TIMEOUT_KEY = "jobQueuingTimeout";

  public static final String JOB_RUNNING_TIMEOUT_KEY = "jobRunningTimeout";

  public static final String RETRY_TIMEOUT_KEY = "jobRetryTimeout";

  public static final String RETRY_COUNT_KEY = "jobRetryCount";
  public static final String EXECUTE_ONCE_KEY = "executeOnce";

  public static final String LOAD_BALANCE_KEY = "loadBalance";

  public static final String REUSE_EXCLUSION_KEY = "reuseExclusion";

  public static final String TENANT_KEY = "tenant";

  public static final String FIXED_EC_KEY = "fixedEngineConn";
}
