/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.writers;

import com.anotherbigidea.flash.SWFActionCodes;
import com.anotherbigidea.flash.interfaces.SWFActionBlock;
import com.anotherbigidea.io.OutStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ActionBlockWriter
implements SWFActionBlock,
SWFActionCodes {
    protected OutStream mOut;
    protected ByteArrayOutputStream mByteOut;
    protected List mFixers;
    protected Map mLabelToInfo;
    protected int[] mActionCount;
    protected List mPushValues = new ArrayList();
    protected int mFlashVersion;
    protected String mStringEncoding;

    public ActionBlockWriter(int n) {
        this.mByteOut = new ByteArrayOutputStream();
        this.mOut = new OutStream(this.mByteOut);
        this.mFixers = new ArrayList();
        this.mLabelToInfo = new HashMap();
        this.mActionCount = new int[]{0};
        this.setFlashVersion(n);
    }

    protected ActionBlockWriter(OutStream outStream, ByteArrayOutputStream byteArrayOutputStream, List list, Map map, int[] nArray, int n) {
        this.mByteOut = byteArrayOutputStream;
        this.mOut = outStream;
        this.mFixers = list;
        this.mLabelToInfo = map;
        this.mActionCount = nArray;
        this.setFlashVersion(n);
    }

    private void setFlashVersion(int n) {
        this.mFlashVersion = n;
        this.mStringEncoding = n >= 6 ? "UTF-8" : "US-ASCII";
    }

    public byte[] getActionData() throws IOException {
        this.mOut.flush();
        this.mOut.close();
        byte[] byArray = this.mByteOut.toByteArray();
        Iterator iterator = this.mFixers.iterator();
        while (iterator.hasNext()) {
            Fixer fixer = (Fixer)iterator.next();
            fixer.fix(byArray);
        }
        return byArray;
    }

    protected void writeCode(int n) throws IOException {
        if (this.mPushValues.size() > 0 && n != 150) {
            this.flushPushValues();
        }
        this.mOut.writeUI8(n);
        this.mActionCount[0] = this.mActionCount[0] + 1;
    }

    public void end() throws IOException {
        this.writeCode(0);
    }

    public void blob(byte[] byArray) throws IOException {
        this.mOut.write(byArray);
    }

    public void comment(String string) throws IOException {
    }

    public void unknown(int n, byte[] byArray) throws IOException {
        int n2;
        this.writeCode(n);
        int n3 = n2 = byArray != null ? byArray.length : 0;
        if (n >= 128 || n2 > 0) {
            this.mOut.writeUI16(n2);
        }
        if (n2 > 0) {
            this.mOut.write(byArray);
        }
    }

    public void initArray() throws IOException {
        this.writeCode(66);
    }

    public void jumpLabel(String string) throws IOException {
        if (this.mPushValues.size() > 0) {
            this.flushPushValues();
        }
        int n = this.mOut.getCount();
        LabelInfo labelInfo = new LabelInfo(string, n, this.mActionCount[0]);
        this.mLabelToInfo.put(string, labelInfo);
    }

    public void gotoFrame(int n) throws IOException {
        this.writeCode(129);
        this.mOut.writeUI16(2);
        this.mOut.writeUI16(n);
    }

    public void gotoFrame(String string) throws IOException {
        this.writeCode(140);
        this.mOut.writeUI16(OutStream.getStringLength(string));
        this.mOut.writeString(string, this.mStringEncoding);
    }

    public void getURL(String string, String string2) throws IOException {
        this.writeCode(131);
        this.mOut.writeUI16(OutStream.getStringLength(string) + OutStream.getStringLength(string2));
        this.mOut.writeString(string, this.mStringEncoding);
        this.mOut.writeString(string2, this.mStringEncoding);
    }

    public void nextFrame() throws IOException {
        this.writeCode(4);
    }

    public void prevFrame() throws IOException {
        this.writeCode(5);
    }

    public void play() throws IOException {
        this.writeCode(6);
    }

    public void stop() throws IOException {
        this.writeCode(7);
    }

    public void toggleQuality() throws IOException {
        this.writeCode(8);
    }

    public void stopSounds() throws IOException {
        this.writeCode(9);
    }

    public void setTarget(String string) throws IOException {
        this.writeCode(139);
        this.mOut.writeUI16(OutStream.getStringLength(string));
        this.mOut.writeString(string, this.mStringEncoding);
    }

    protected void writeJump(String string, int n) throws IOException {
        this.writeCode(n);
        this.mOut.writeUI16(2);
        int n2 = this.mOut.getCount();
        this.mOut.writeUI16(0);
        this.mFixers.add(new OffsetFixer(this.mOut.getCount(), n2, string));
    }

    public void jump(String string) throws IOException {
        this.writeJump(string, 153);
    }

    public void ifJump(String string) throws IOException {
        this.writeJump(string, 157);
    }

    public void waitForFrame(int n, String string) throws IOException {
        this.writeCode(138);
        this.mOut.writeUI16(3);
        this.mOut.writeUI16(n);
        int n2 = this.mOut.getCount();
        this.mOut.writeUI8(0);
        int n3 = this.mActionCount[0];
        SkipActionFixer skipActionFixer = new SkipActionFixer(n3, n2, string);
        this.mFixers.add(skipActionFixer);
    }

    public void waitForFrame(String string) throws IOException {
        this.writeCode(141);
        this.mOut.writeUI16(1);
        int n = this.mOut.getCount();
        this.mOut.writeUI8(0);
        int n2 = this.mActionCount[0];
        SkipActionFixer skipActionFixer = new SkipActionFixer(n2, n, string);
        this.mFixers.add(skipActionFixer);
    }

    public void pop() throws IOException {
        this.writeCode(23);
    }

    public void add() throws IOException {
        this.writeCode(10);
    }

    public void substract() throws IOException {
        this.writeCode(11);
    }

    public void multiply() throws IOException {
        this.writeCode(12);
    }

    public void divide() throws IOException {
        this.writeCode(13);
    }

    public void equals() throws IOException {
        this.writeCode(14);
    }

    public void lessThan() throws IOException {
        this.writeCode(15);
    }

    public void and() throws IOException {
        this.writeCode(16);
    }

    public void or() throws IOException {
        this.writeCode(17);
    }

    public void not() throws IOException {
        this.writeCode(18);
    }

    public void stringEquals() throws IOException {
        this.writeCode(19);
    }

    public void stringLength() throws IOException {
        this.writeCode(20);
    }

    public void concat() throws IOException {
        this.writeCode(33);
    }

    public void substring() throws IOException {
        this.writeCode(21);
    }

    public void stringLessThan() throws IOException {
        this.writeCode(41);
    }

    public void stringLengthMB() throws IOException {
        this.writeCode(49);
    }

    public void substringMB() throws IOException {
        this.writeCode(53);
    }

    public void toInteger() throws IOException {
        this.writeCode(24);
    }

    public void charToAscii() throws IOException {
        this.writeCode(50);
    }

    public void asciiToChar() throws IOException {
        this.writeCode(51);
    }

    public void charMBToAscii() throws IOException {
        this.writeCode(54);
    }

    public void asciiToCharMB() throws IOException {
        this.writeCode(55);
    }

    public void call() throws IOException {
        this.writeCode(158);
        this.mOut.writeUI16(0);
    }

    public void getVariable() throws IOException {
        this.writeCode(28);
    }

    public void setVariable() throws IOException {
        this.writeCode(29);
    }

    public void getURL(int n, int n2) throws IOException {
        this.writeCode(154);
        this.mOut.writeUI16(1);
        int n3 = 0;
        Object var4_4 = null;
        switch (n) {
            case 1: {
                n3 = 1;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object var5_5 = null;
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                n3 |= 0x40;
                break;
            }
            case 3: {
                n3 |= 0x80;
                break;
            }
            case 4: {
                n3 |= 0xC0;
                break;
            }
        }
        this.mOut.writeUI8(n3);
    }

    public void gotoFrame(boolean bl) throws IOException {
        this.writeCode(159);
        this.mOut.writeUI16(1);
        this.mOut.writeUI8(bl ? 1 : 0);
    }

    public void setTarget() throws IOException {
        this.writeCode(32);
    }

    public void getProperty() throws IOException {
        this.writeCode(34);
    }

    public void setProperty() throws IOException {
        this.writeCode(35);
    }

    public void cloneSprite() throws IOException {
        this.writeCode(36);
    }

    public void removeSprite() throws IOException {
        this.writeCode(37);
    }

    public void startDrag() throws IOException {
        this.writeCode(39);
    }

    public void endDrag() throws IOException {
        this.writeCode(40);
    }

    public void trace() throws IOException {
        this.writeCode(38);
    }

    public void getTime() throws IOException {
        this.writeCode(52);
    }

    public void randomNumber() throws IOException {
        this.writeCode(48);
    }

    public void lookupTable(String[] stringArray) throws IOException {
        this.writeCode(136);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutStream outStream = new OutStream(byteArrayOutputStream);
        outStream.writeUI16(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            outStream.writeString(stringArray[i], this.mStringEncoding);
        }
        outStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.mOut.writeUI16(byArray.length);
        this.mOut.write(byArray);
    }

    public void callFunction() throws IOException {
        this.writeCode(61);
    }

    public void callMethod() throws IOException {
        this.writeCode(82);
    }

    public SWFActionBlock startFunction(String string, String[] stringArray) throws IOException {
        this.writeCode(155);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutStream outStream = new OutStream(byteArrayOutputStream);
        outStream.writeString(string, this.mStringEncoding);
        outStream.writeUI16(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            outStream.writeString(stringArray[i], this.mStringEncoding);
        }
        outStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.mOut.writeUI16(byArray.length + 2);
        this.mOut.write(byArray);
        int n = this.mOut.getCount();
        this.mOut.writeUI16(0);
        BlockLengthFixer blockLengthFixer = new BlockLengthFixer(n);
        this.mFixers.add(blockLengthFixer);
        SubBlockWriter subBlockWriter = new SubBlockWriter(blockLengthFixer, this.mOut, this.mByteOut, this.mFixers, this.mLabelToInfo, this.mActionCount, this.mFlashVersion);
        return subBlockWriter;
    }

    public SWFActionBlock startFunction2(String string, int n, int n2, String[] stringArray, int[] nArray) throws IOException {
        this.writeCode(142);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutStream outStream = new OutStream(byteArrayOutputStream);
        outStream.writeString(string, this.mStringEncoding);
        outStream.writeUI16(stringArray.length);
        outStream.writeUI8(n);
        outStream.writeUI16(n2);
        for (int i = 0; i < stringArray.length; ++i) {
            outStream.writeUI8(nArray[i]);
            outStream.writeString(stringArray[i], this.mStringEncoding);
        }
        outStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.mOut.writeUI16(byArray.length + 2);
        this.mOut.write(byArray);
        int n3 = this.mOut.getCount();
        this.mOut.writeUI16(0);
        BlockLengthFixer blockLengthFixer = new BlockLengthFixer(n3);
        this.mFixers.add(blockLengthFixer);
        SubBlockWriter subBlockWriter = new SubBlockWriter(blockLengthFixer, this.mOut, this.mByteOut, this.mFixers, this.mLabelToInfo, this.mActionCount, this.mFlashVersion);
        return subBlockWriter;
    }

    public SWFActionBlock.TryCatchFinally _try(String string) throws IOException {
        return this._try(string, 0);
    }

    public SWFActionBlock.TryCatchFinally _try(int n) throws IOException {
        return this._try(null, n);
    }

    private SWFActionBlock.TryCatchFinally _try(String string, int n) throws IOException {
        this.writeCode(143);
        int n2 = this.mOut.getCount();
        this.mOut.writeUI16(0);
        BlockLengthFixer blockLengthFixer = new BlockLengthFixer(n2);
        this.mFixers.add(blockLengthFixer);
        int n3 = this.mOut.getCount();
        this.mOut.writeUI8(0);
        final TryFlagsFixer tryFlagsFixer = new TryFlagsFixer(n3);
        this.mFixers.add(tryFlagsFixer);
        int n4 = this.mOut.getCount();
        this.mOut.writeUI16(0);
        final BlockLengthFixer blockLengthFixer2 = new BlockLengthFixer(n4);
        this.mFixers.add(blockLengthFixer2);
        int n5 = this.mOut.getCount();
        this.mOut.writeUI16(0);
        final BlockLengthFixer blockLengthFixer3 = new BlockLengthFixer(n5);
        this.mFixers.add(blockLengthFixer3);
        int n6 = this.mOut.getCount();
        this.mOut.writeUI16(0);
        final BlockLengthFixer blockLengthFixer4 = new BlockLengthFixer(n6);
        this.mFixers.add(blockLengthFixer4);
        if (string != null) {
            this.mOut.writeString(string, this.mStringEncoding);
        } else {
            this.mOut.writeUI8(n);
            tryFlagsFixer.catchInRegister();
        }
        blockLengthFixer.setBlockLength(this.mOut.getCount() - n3);
        return new SWFActionBlock.TryCatchFinally(){

            public SWFActionBlock tryBlock() throws IOException {
                return new SubBlockWriter(blockLengthFixer2, ActionBlockWriter.this.mOut, ActionBlockWriter.this.mByteOut, ActionBlockWriter.this.mFixers, ActionBlockWriter.this.mLabelToInfo, ActionBlockWriter.this.mActionCount, ActionBlockWriter.this.mFlashVersion);
            }

            public SWFActionBlock catchBlock() throws IOException {
                tryFlagsFixer.hasCatchBlock();
                return new SubBlockWriter(blockLengthFixer3, ActionBlockWriter.this.mOut, ActionBlockWriter.this.mByteOut, ActionBlockWriter.this.mFixers, ActionBlockWriter.this.mLabelToInfo, ActionBlockWriter.this.mActionCount, ActionBlockWriter.this.mFlashVersion);
            }

            public SWFActionBlock finallyBlock() throws IOException {
                tryFlagsFixer.hasFinallyBlock();
                return new SubBlockWriter(blockLengthFixer4, ActionBlockWriter.this.mOut, ActionBlockWriter.this.mByteOut, ActionBlockWriter.this.mFixers, ActionBlockWriter.this.mLabelToInfo, ActionBlockWriter.this.mActionCount, ActionBlockWriter.this.mFlashVersion);
            }

            public void endTry() throws IOException {
            }
        };
    }

    public void defineLocalValue() throws IOException {
        this.writeCode(60);
    }

    public void defineLocal() throws IOException {
        this.writeCode(65);
    }

    public void deleteProperty() throws IOException {
        this.writeCode(58);
    }

    public void deleteThreadVars() throws IOException {
        this.writeCode(59);
    }

    public void enumerate() throws IOException {
        this.writeCode(70);
    }

    public void typedEquals() throws IOException {
        this.writeCode(73);
    }

    public void getMember() throws IOException {
        this.writeCode(78);
    }

    public void initObject() throws IOException {
        this.writeCode(67);
    }

    public void newMethod() throws IOException {
        this.writeCode(83);
    }

    public void newObject() throws IOException {
        this.writeCode(64);
    }

    public void setMember() throws IOException {
        this.writeCode(79);
    }

    public void getTargetPath() throws IOException {
        this.writeCode(69);
    }

    public SWFActionBlock startWith() throws IOException {
        this.writeCode(148);
        this.mOut.writeUI16(2);
        int n = this.mOut.getCount();
        this.mOut.writeUI16(0);
        BlockLengthFixer blockLengthFixer = new BlockLengthFixer(n);
        this.mFixers.add(blockLengthFixer);
        SubBlockWriter subBlockWriter = new SubBlockWriter(blockLengthFixer, this.mOut, this.mByteOut, this.mFixers, this.mLabelToInfo, this.mActionCount, this.mFlashVersion);
        return subBlockWriter;
    }

    public void duplicate() throws IOException {
        this.writeCode(76);
    }

    public void returnValue() throws IOException {
        this.writeCode(62);
    }

    public void swap() throws IOException {
        this.writeCode(77);
    }

    public void storeInRegister(int n) throws IOException {
        this.writeCode(135);
        this.mOut.writeUI16(1);
        this.mOut.writeUI8(n);
    }

    public void convertToNumber() throws IOException {
        this.writeCode(74);
    }

    public void convertToString() throws IOException {
        this.writeCode(75);
    }

    public void typeOf() throws IOException {
        this.writeCode(68);
    }

    public void typedAdd() throws IOException {
        this.writeCode(71);
    }

    public void typedLessThan() throws IOException {
        this.writeCode(72);
    }

    public void modulo() throws IOException {
        this.writeCode(63);
    }

    public void bitAnd() throws IOException {
        this.writeCode(96);
    }

    public void bitOr() throws IOException {
        this.writeCode(97);
    }

    public void bitXor() throws IOException {
        this.writeCode(98);
    }

    public void shiftLeft() throws IOException {
        this.writeCode(99);
    }

    public void shiftRight() throws IOException {
        this.writeCode(100);
    }

    public void shiftRightUnsigned() throws IOException {
        this.writeCode(101);
    }

    public void decrement() throws IOException {
        this.writeCode(81);
    }

    public void increment() throws IOException {
        this.writeCode(80);
    }

    protected void flushPushValues() throws IOException {
        this.writeCode(150);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutStream outStream = new OutStream(byteArrayOutputStream);
        Object object = this.mPushValues.iterator();
        while (object.hasNext()) {
            PushValue pushValue = (PushValue)object.next();
            pushValue.write(outStream);
        }
        this.mPushValues.clear();
        outStream.flush();
        object = byteArrayOutputStream.toByteArray();
        this.mOut.writeUI16(((Object)object).length);
        this.mOut.write((byte[])object);
    }

    private void push(PushValue pushValue) throws IOException {
        this.mPushValues.add(pushValue);
        if (this.mFlashVersion < 5) {
            this.flushPushValues();
        }
    }

    public void push(String string) throws IOException {
        this.push(new PushStringVal(string));
    }

    public void push(float f) throws IOException {
        this.push(new PushFloatVal(f));
    }

    public void push(double d) throws IOException {
        this.push(new PushDoubleVal(d));
    }

    public void pushNull() throws IOException {
        this.push(new PushNull());
    }

    public void pushUndefined() throws IOException {
        this.push(new PushUndefined());
    }

    public void pushRegister(int n) throws IOException {
        this.push(new PushRegister(n));
    }

    public void push(boolean bl) throws IOException {
        this.push(new PushBooleanVal(bl));
    }

    public void push(int n) throws IOException {
        this.push(new PushIntegerVal(n));
    }

    public void lookup(int n) throws IOException {
        this.push(new PushLookup(n));
    }

    public void enumerateObject() throws IOException {
        this.writeCode(85);
    }

    public void greaterThan() throws IOException {
        this.writeCode(103);
    }

    public void instanceOf() throws IOException {
        this.writeCode(84);
    }

    public void strictEquals() throws IOException {
        this.writeCode(102);
    }

    public void stringGreaterThan() throws IOException {
        this.writeCode(104);
    }

    public void _extends() throws IOException {
        this.writeCode(105);
    }

    public void _implements() throws IOException {
        this.writeCode(44);
    }

    public void _throw() throws IOException {
        this.writeCode(42);
    }

    public void cast() throws IOException {
        this.writeCode(43);
    }

    protected static class SubBlockWriter
    extends ActionBlockWriter {
        private BlockLengthFixer mLengthFixer;
        private int mInitOffset;

        SubBlockWriter(BlockLengthFixer blockLengthFixer, OutStream outStream, ByteArrayOutputStream byteArrayOutputStream, List list, Map map, int[] nArray, int n) {
            super(outStream, byteArrayOutputStream, list, map, nArray, n);
            this.mLengthFixer = blockLengthFixer;
            this.mInitOffset = outStream.getCount();
        }

        public void end() throws IOException {
            int n = this.mOut.getCount() - this.mInitOffset;
            this.mLengthFixer.setBlockLength(n);
        }
    }

    class PushNull
    implements PushValue {
        PushNull() {
        }

        public void write(OutStream outStream) throws IOException {
            outStream.writeUI8(2);
        }
    }

    class PushDoubleVal
    implements PushValue {
        private double value;

        public void write(OutStream outStream) throws IOException {
            outStream.writeUI8(6);
            outStream.writeDouble(this.value);
        }

        PushDoubleVal(double d) {
            this.value = d;
        }
    }

    class PushFloatVal
    implements PushValue {
        private float value;

        public void write(OutStream outStream) throws IOException {
            outStream.writeUI8(1);
            outStream.writeFloat(this.value);
        }

        PushFloatVal(float f) {
            this.value = f;
        }
    }

    class PushRegister
    implements PushValue {
        private int value;

        public void write(OutStream outStream) throws IOException {
            outStream.writeUI8(4);
            outStream.writeUI8(this.value);
        }

        PushRegister(int n) {
            this.value = n;
        }
    }

    class PushLookup
    implements PushValue {
        private int idx;

        public void write(OutStream outStream) throws IOException {
            if (this.idx <= 255) {
                outStream.writeUI8(8);
                outStream.writeUI8(this.idx);
            } else {
                outStream.writeUI8(9);
                outStream.writeUI16(this.idx);
            }
        }

        PushLookup(int n) {
            this.idx = n;
        }
    }

    class PushIntegerVal
    implements PushValue {
        private int value;

        public void write(OutStream outStream) throws IOException {
            outStream.writeUI8(7);
            outStream.writeSI32(this.value);
        }

        PushIntegerVal(int n) {
            this.value = n;
        }
    }

    class PushBooleanVal
    implements PushValue {
        private boolean value;

        public void write(OutStream outStream) throws IOException {
            outStream.writeUI8(5);
            outStream.writeUI8(this.value ? 1 : 0);
        }

        PushBooleanVal(boolean bl) {
            this.value = bl;
        }
    }

    class PushStringVal
    implements PushValue {
        private String value;

        public void write(OutStream outStream) throws IOException {
            outStream.writeUI8(0);
            outStream.writeString(this.value, ActionBlockWriter.this.mStringEncoding);
        }

        PushStringVal(String string) {
            this.value = string;
        }
    }

    class PushUndefined
    implements PushValue {
        PushUndefined() {
        }

        public void write(OutStream outStream) throws IOException {
            outStream.writeUI8(3);
        }
    }

    static interface PushValue {
        public void write(OutStream var1) throws IOException;
    }

    private static class LabelInfo {
        public final String label;
        public final int offset;
        public final int actionNumber;

        public LabelInfo(String string, int n, int n2) {
            this.label = string;
            this.offset = n;
            this.actionNumber = n2;
        }
    }

    private class TryFlagsFixer
    implements Fixer {
        private int mFlagsAddr;
        private int mFlags = 0;

        TryFlagsFixer(int n) {
            this.mFlagsAddr = n;
        }

        public void hasCatchBlock() {
            this.mFlags |= 1;
        }

        public void hasFinallyBlock() {
            this.mFlags |= 2;
        }

        public void catchInRegister() {
            this.mFlags |= 4;
        }

        public void fix(byte[] byArray) {
            byArray[this.mFlagsAddr] = (byte)(this.mFlags & 0xFF);
        }
    }

    private class BlockLengthFixer
    implements Fixer {
        private int mBlockLengthAddr;
        private int mBlockLength;

        BlockLengthFixer(int n) {
            this.mBlockLengthAddr = n;
        }

        public void setBlockLength(int n) {
            this.mBlockLength = n;
        }

        public void fix(byte[] byArray) {
            byArray[this.mBlockLengthAddr] = (byte)(this.mBlockLength & 0xFF);
            byArray[this.mBlockLengthAddr + 1] = (byte)(this.mBlockLength >> 8 & 0xFF);
        }
    }

    private class SkipActionFixer
    implements Fixer {
        private int mSkipCountAddr;
        private int mBaseActionCount;
        private String mTargetLabel;

        SkipActionFixer(int n, int n2, String string) {
            this.mBaseActionCount = n;
            this.mSkipCountAddr = n2;
            this.mTargetLabel = string;
        }

        public void fix(byte[] byArray) {
            LabelInfo labelInfo = (LabelInfo)ActionBlockWriter.this.mLabelToInfo.get(this.mTargetLabel);
            int n = labelInfo.actionNumber - this.mBaseActionCount;
            byArray[this.mSkipCountAddr] = (byte)n;
        }
    }

    private class OffsetFixer
    implements Fixer {
        private int mBaseOffset;
        private int mOffsetAddr;
        private String mTargetLabel;

        OffsetFixer(int n, int n2, String string) {
            this.mBaseOffset = n;
            this.mOffsetAddr = n2;
            this.mTargetLabel = string;
        }

        public void fix(byte[] byArray) {
            LabelInfo labelInfo = (LabelInfo)ActionBlockWriter.this.mLabelToInfo.get(this.mTargetLabel);
            int n = labelInfo.offset - this.mBaseOffset;
            byArray[this.mOffsetAddr] = (byte)(n & 0xFF);
            byArray[this.mOffsetAddr + 1] = (byte)(n >> 8 & 0xFF);
        }
    }

    static interface Fixer {
        public void fix(byte[] var1);
    }
}

