/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.nutch.core.jsoup.extractor;

public class JsoupExtractorConstants {
  public static final String JSOUP_DOC_PROPERTY_FILE = "jsoup.extractor.property.file";
  public static final String JSOUP_DOC_DEFAULT_FILE = "jsoup-extractor.xml";
  public static final String TAG_DOCUMENT = "document";
  public static final String ATTR_URL_PATTERN = "url-pattern";
  public static final String TAG_FIELD_LIST = "fields";
  public static final String TAG_FIELD = "field";
  public static final String ATTR_NAME = "name";
  public static final String TAG_CSS_SELECTOR = "css-selector";
  public static final String TAG_ATTRIBUTE = "attribute";
  public static final String TAG_DEFAULT_VALUE = "default-value";
  public static final String TAG_NORMALIZER_LIST = "normalizers";
  public static final String TAG_TYPE_LIST = "types";
  public static final String TAG_NORMALIZER = "normalizer";
  public static final String TAG_TYPE = "type";
  public static final String ATTR_CLASS = "class";
}
