/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.webbeans.ee.beans;

import jakarta.inject.Provider;
import jakarta.validation.Validator;

import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.ValidatorService;

import java.io.ObjectStreamException;
import java.io.Serializable;

public class ValidatorProvider implements Provider<Validator>, Serializable
{

    private transient WebBeansContext webBeansContext;
    
    public ValidatorProvider(WebBeansContext webBeansContext)
    {
        this.webBeansContext = webBeansContext;
    }

    @Override
    public Validator get()
    {
        if (webBeansContext == null)
        {
            webBeansContext = WebBeansContext.currentInstance();
        }

        ValidatorService validatorService = webBeansContext.getService(ValidatorService.class);
        if(validatorService != null)
        {
            return validatorService.getDefaultValidator();
        }        
        return null;
    }

    Object readResolve() throws ObjectStreamException
    {
        return get();
    }
}
