/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.gems.browser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.portals.applications.gems.browser.Browser;
import org.apache.portals.applications.gems.browser.BrowserIterator;
import org.apache.portals.applications.gems.browser.StatusMessage;
import org.apache.portals.bridges.velocity.GenericVelocityPortlet;
import org.apache.portals.messaging.PortletMessaging;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserPortlet
extends GenericVelocityPortlet
implements Browser {
    protected static final String SQL = "sql";
    public static final String TABLE_NAME = "tableName";
    public static final String CONDITIONS = "conditions";
    public static final String Order_BY_COLUMNS = "orderByColumns";
    public static final String COLUMNS = "columnNames";
    protected static final String POOLNAME = "poolname";
    protected static final String START = "start";
    protected static final String FIND = "find";
    protected static final String SEARCH_STRING = "searchString";
    protected static final String SEARCH_COLUMN = "searchColumn";
    protected static final String FILTERED = "filtered";
    protected static final String FILTER = "filter";
    protected static final String CUSTOMIZE_TEMPLATE = "customizeTemplate";
    protected static final String WINDOW_SIZE = "WindowSize";
    protected static final String USER_OBJECT_NAMES = "user-object-names";
    protected static final String USER_OBJECT_TYPES = "user-object-types";
    protected static final String USER_OBJECTS = "user-objects";
    protected static final String SQL_PARAM_PREFIX = "sqlparam";
    protected static final String LINKS_READ = "linksRead";
    protected static final String ROW_LINK = "rowLinks";
    protected static final String TABLE_LINK = "tableLinks";
    protected static final String ROW_LINK_IDS = "row-link-ids";
    protected static final String ROW_LINK_TYPES = "row-link-types";
    protected static final String ROW_LINK_TARGETS = "row-link-targets";
    protected static final String TABLE_LINK_IDS = "table-link-ids";
    protected static final String TABLE_LINK_TYPES = "table-link-types";
    protected static final String TABLE_LINK_TARGETS = "table-link-targets";
    protected static final String BROWSER_TABLE_SIZE = "tableSize";
    protected static final String BROWSER_ACTION_KEY = "browser_action_key";
    protected static final String BROWSER_ITERATOR = "table";
    protected static final String BROWSER_TITLE_ITERATOR = "title";
    protected static final String NEXT = "next";
    protected static final String PREVIOUS = "prev";
    protected static final String FIRST = "first";
    protected static final String LAST = "last";
    protected static final String VELOCITY_NULL_ENTRY = "-";
    protected static final String PEID = "js_peid";
    protected static final String SORT_COLUMN_NAME = "js_dbcolumn";
    protected static final String SORT_ORDER = "sortOrder";
    protected List sqlParameters = new Vector();
    protected PortletContext context;
    protected Logger log = LoggerFactory.getLogger(BrowserPortlet.class);

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.context = this.getPortletContext();
    }

    @Override
    public void getRows(RenderRequest request, String sql, int windowSize) throws Exception {
    }

    public void getRows(RenderRequest request, String sql, int windowSize, String filter) throws Exception {
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        BrowserIterator iterator = this.getBrowserIterator((PortletRequest)request);
        Context context = this.getContext(request);
        String sortColName = request.getParameter(SORT_COLUMN_NAME);
        String sortorder = request.getParameter(SORT_ORDER);
        int start = this.getStartVariable(request, START, sortColName, iterator);
        PortletPreferences prefs = request.getPreferences();
        int windowSize = Integer.parseInt(prefs.getValue(WINDOW_SIZE, "10"));
        StatusMessage message = (StatusMessage)PortletMessaging.consume((PortletRequest)request, (String)"DatabaseBrowserPortlet", (String)"action");
        if (sortorder == null) {
            sortorder = "DESC";
        }
        if (message != null) {
            this.getContext(request).put("statusMsg", (Object)message);
        }
        try {
            if (iterator == null) {
                String sql = this.getQueryString(request, context);
                this.readUserParameters(request, context);
                String filter = request.getParameter(FILTER);
                if (filter != null) {
                    this.getRows(request, sql, windowSize, filter);
                } else {
                    this.getRows(request, sql, windowSize);
                }
                iterator = this.getBrowserIterator((PortletRequest)request);
                start = 0;
            } else if (sortColName != null) {
                iterator.sort(sortColName);
            }
            int resultSetSize = iterator.getResultSetSize();
            if (start >= resultSetSize) {
                start = start - windowSize > 0 ? resultSetSize - windowSize : 0;
            }
            int next = start + windowSize;
            int prev = start - windowSize;
            if (prev < 0 && start > 0) {
                prev = 0;
            }
            iterator.setTop(start);
            this.readLinkParameters(request, context);
            if (iterator != null) {
                resultSetSize = iterator.getResultSetSize();
                if (next < resultSetSize) {
                    context.put(NEXT, (Object)String.valueOf(next));
                }
                if (prev <= resultSetSize && prev >= 0) {
                    context.put(PREVIOUS, (Object)String.valueOf(prev));
                }
                context.put(BROWSER_ITERATOR, (Object)iterator);
                context.put(BROWSER_TITLE_ITERATOR, (Object)iterator.getResultSetTitleList());
                context.put(BROWSER_TABLE_SIZE, (Object)new Integer(resultSetSize));
                context.put(WINDOW_SIZE, (Object)new Integer(windowSize));
                context.put(START, (Object)new Integer(start));
                if (sortorder.equals("ASC")) {
                    context.put(SORT_ORDER, (Object)"DESC");
                } else {
                    context.put(SORT_ORDER, (Object)"ASC");
                }
            }
        }
        catch (Exception e) {
            String msg = e.toString();
            Throwable cause = e.getCause();
            if (cause != null) {
                msg = msg + ", " + cause.getMessage();
            }
            context.put("statusMsg", (Object)new StatusMessage(msg, "portlet-msg-error"));
            this.log.error("Exception", (Throwable)e);
        }
        super.doView(request, response);
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        this.doPreferencesEdit(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        if (request.getPortletMode() == PortletMode.EDIT) {
            this.processPreferencesAction(request, response);
            this.clearBrowserIterator((PortletRequest)request);
        } else {
            String browserAction = request.getParameter("db.browser.action");
            if (browserAction != null) {
                String searchString;
                String start;
                if (browserAction.equals("refresh")) {
                    this.clearBrowserIterator((PortletRequest)request);
                }
                if ((start = request.getParameter(START)) != null) {
                    response.setRenderParameter(START, start);
                }
                if ((searchString = request.getParameter(SEARCH_STRING)) != null) {
                    String searchColumn = request.getParameter(SEARCH_COLUMN);
                    String filtered = request.getParameter(FILTERED);
                    if (filtered != null) {
                        this.clearBrowserIterator((PortletRequest)request);
                        response.setRenderParameter(FILTER, searchString);
                    } else {
                        int index = this.find(this.getBrowserIterator((PortletRequest)request), searchString, searchColumn);
                        if (index == -1) {
                            try {
                                StatusMessage sm = new StatusMessage("Could not find match for: " + searchString, "portlet-msg-alert");
                                PortletMessaging.publish((PortletRequest)request, (String)"DatabaseBrowserPortlet", (String)"action", (Object)sm);
                            }
                            catch (Exception e) {}
                        } else {
                            response.setRenderParameter(START, Integer.toString(index));
                        }
                    }
                }
            }
        }
    }

    protected BrowserIterator getBrowserIterator(PortletRequest request) {
        BrowserIterator iterator = (BrowserIterator)request.getPortletSession().getAttribute(BROWSER_ACTION_KEY, 2);
        return iterator;
    }

    protected void setBrowserIterator(RenderRequest request, BrowserIterator iterator) {
        request.getPortletSession().setAttribute(BROWSER_ACTION_KEY, (Object)iterator);
    }

    protected void clearBrowserIterator(PortletRequest request) {
        request.getPortletSession().removeAttribute(BROWSER_ACTION_KEY);
    }

    protected int getStartVariable(RenderRequest request, String attrName, String sortColName, BrowserIterator iterator) {
        int start = -1;
        if (sortColName != null) {
            start = this.getStartIndex();
        }
        if (start < 0) {
            block9: {
                String startStr = request.getParameter(attrName);
                if (startStr != null && startStr.length() > 0) {
                    try {
                        start = Integer.parseInt(startStr);
                    }
                    catch (Exception e) {
                        if (iterator != null) {
                            start = iterator.getTop();
                            break block9;
                        }
                        start = 0;
                    }
                } else if (start == -1 && iterator != null) {
                    start = iterator.getTop();
                }
            }
            if (start < 0) {
                start = 0;
            }
        }
        return start;
    }

    protected int getStartIndex() {
        return 0;
    }

    protected String getQueryString(RenderRequest request, Context context) {
        String sql = this.getQueryString((PortletRequest)request);
        if (null == sql) {
            sql = this.getPreference((PortletRequest)request, SQL, null);
        }
        return sql;
    }

    public String getQueryString(PortletRequest request) {
        return null;
    }

    protected String getPreference(PortletRequest request, String attrName, String attrDefValue) {
        return request.getPreferences().getValue(attrName, attrDefValue);
    }

    protected void readUserParameters(RenderRequest request, Context context) {
        Object userObjRead = request.getPortletSession().getAttribute(USER_OBJECTS, 2);
        if (userObjRead != null) {
            context.put(USER_OBJECTS, userObjRead);
        }
    }

    protected void readSqlParameters(PortletRequest request) {
        String param;
        ArrayList<String> sqlParamList = null;
        int i = 1;
        while ((param = this.getPreference(request, SQL_PARAM_PREFIX + i, null)) != null) {
            if (sqlParamList == null) {
                sqlParamList = new ArrayList<String>();
            }
            sqlParamList.add(param);
            ++i;
        }
        if (sqlParamList != null) {
            this.setSQLParameters(sqlParamList);
        }
    }

    public void setSQLParameters(List parameters) {
        this.sqlParameters = parameters;
    }

    protected void readLinkParameters(RenderRequest request, Context context) {
    }

    @Override
    public void populate(int rowIndex, int columnIndex, List row) {
    }

    @Override
    public boolean filter(List row, RenderRequest request) {
        return false;
    }

    public void publishStatusMessage(PortletRequest request, String portlet, String topic, Throwable e, String message) {
        String msg = message + ": " + e.toString();
        Throwable cause = e.getCause();
        if (cause != null) {
            msg = msg + ", " + cause.getMessage();
        }
        StatusMessage sm = new StatusMessage(msg, "portlet-msg-error");
        try {
            PortletMessaging.publish((PortletRequest)request, (String)portlet, (String)topic, (Object)sm);
        }
        catch (Exception ee) {
            System.err.println("Failed to publish message: " + e);
        }
    }

    public int find(BrowserIterator iterator, String searchString, String searchColumn) {
        int index = 0;
        int column = 1;
        if (searchColumn != null) {
            column = Integer.parseInt(searchColumn);
        }
        for (Object row : iterator.getResultSet()) {
            String item = "";
            if (row instanceof String) {
                item = (String)row;
            } else if (row instanceof List) {
                item = (String)((List)row).get(column);
            }
            if (item.startsWith(searchString)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public List getTitleList(PortletRequest request) {
        return null;
    }
}

