/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.gems.flash;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.portals.bridges.velocity.GenericVelocityPortlet;
import org.apache.portals.gems.flash.SWFHeader;
import org.apache.portals.gems.util.JSONUtils;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlashPortlet
extends GenericVelocityPortlet {
    public static final String HEIGHT_PREF = "HEIGHT";
    public static final String WIDTH_PREF = "WIDTH";
    public static final String SRC_PREF = "SRC";
    public static final String MAX_SRC_PREF = "MAX-SRC";
    public static final String MAX_HEIGHT_PREF = "MAX-HEIGHT";
    public static final String MAX_WIDTH_PREF = "MAX-WIDTH";
    public static final String OBJECT_PARAMS_INITPARAM = "object-params";
    public static final String OBJECT_ATTRIBUTES_INITPARAM = "object-attributes";
    public static final String FLASHVARS_INITPARAM = "flashvars";
    public static final String VIEW_PAGE_INITPARAM = "ViewPage";
    public static final String PARAM_VIEW_PAGE = "ViewPage";
    public static final String PARAM_EDIT_PAGE = "EditPage";
    public static final String PARAM_VIEW_PAGE_DEFAULT = "org/apache/portals/gems/flash/templates/flash-demo.vm";
    public static final String PARAM_EDIT_PAGE_DEFAULT = "org/apache/portals/gems/flash/templates/edit-prefs.vm";
    public static final String CODEBASE = "codebase";
    public static final String CLASSID = "classid";
    public static final String NODEID = "id";
    public static final String SRC = "SRC";
    public static final String WIDTH = "WIDTH";
    public static final String HEIGHT = "HEIGHT";
    public static final String WIDTH_ACTUAL = "widthActual";
    public static final String HEIGHT_ACTUAL = "heightActual";
    public static final String HEIGHT_PERCENT = "heightPercent";
    public static final String OBJECT_PARAMS = "PARAMS";
    public static final String OBJECT_ATTRIBUTES = "ATTRIBUTES";
    public static final String FLASHVARS = "FLASHVARS";
    public static final String EXTRA_SIZE_INFO = "EXTRA_SIZE_INFO";
    public static final String WINDOW_STATE = "windowState";
    public static final String NAMESPACE = "NAMESPACE";
    public static final String REPLACECONTENT_NODEID = "REPLACECONTENT_NODEID";
    public static final String SWF_VERSION = "SWF_VERSION";
    public static final String SWF_VERSION_DEFAULT = "9.0.0";
    public static final String PARAM_SWFOBJECTS_LIB_URL = "SwfObjectsLibUrl";
    public static final String PARAM_EXPRESS_INSTALL_URL = "ExpressInstallUrl";
    public static final String SWFOBJECTS_LIB_URL = "SWFOBJECTS_URL";
    public static final String EXPRESS_INSTALL_URL = "EXPRESS_INSTALL_URL";
    public static final String IS_DESKTOP = "IS_DESKTOP";
    protected Logger log = LoggerFactory.getLogger(FlashPortlet.class);
    protected String viewPage = null;
    protected String editPage = null;
    protected String defaultSwfObjectsLibUrl = "/javascript/swfobject/swfobject.js";
    protected String defaultSwfExpressInstallUrl = "/javascript/swfobject/expressInstall.swf";
    private Map object_parameters = null;
    private Map object_attributes = null;
    private Map flash_vars = null;
    private VelocityEngine engine;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        String param = config.getInitParameter(PARAM_SWFOBJECTS_LIB_URL);
        if (param != null && !"".equals(param)) {
            this.defaultSwfObjectsLibUrl = param;
        }
        if ((param = config.getInitParameter(PARAM_EXPRESS_INSTALL_URL)) != null && !"".equals(param)) {
            this.defaultSwfExpressInstallUrl = param;
        }
        if ((param = config.getInitParameter("ViewPage")) != null && !"".equals(param)) {
            this.viewPage = param;
        }
        if ((param = config.getInitParameter(PARAM_EDIT_PAGE)) != null && !"".equals(param)) {
            this.editPage = param;
        }
        Map objParams = this.parseSemicolonEqualsDelimitedProps(config.getInitParameter(OBJECT_PARAMS_INITPARAM));
        Map objAttrs = this.parseSemicolonEqualsDelimitedProps(config.getInitParameter(OBJECT_ATTRIBUTES_INITPARAM));
        Map flashVars = this.parseSemicolonEqualsDelimitedProps(config.getInitParameter(FLASHVARS_INITPARAM));
        if (objAttrs != null) {
            objAttrs.remove(CODEBASE);
            objAttrs.remove(CLASSID);
            objAttrs.remove(NODEID);
            this.object_attributes = Collections.unmodifiableMap(objAttrs);
        }
        if (objParams != null) {
            objParams.remove(CODEBASE);
            objParams.remove(CLASSID);
            objParams.remove(NODEID);
            this.object_parameters = Collections.unmodifiableMap(new HashMap(objParams));
        }
        if (flashVars != null) {
            this.flash_vars = Collections.unmodifiableMap(flashVars);
        }
    }

    protected final Map getDefaultObjectParameters() {
        return this.object_parameters;
    }

    protected final Map getDefaultObjectAttributes() {
        return this.object_attributes;
    }

    protected final Map getDefaultFlashVars() {
        return this.flash_vars;
    }

    protected String getDefaultSwfVersion() {
        return SWF_VERSION_DEFAULT;
    }

    protected Map getObjectParameters(RenderRequest request, RenderResponse response, SWFContext swfContext) {
        return this.object_parameters;
    }

    protected Map getObjectAttributes(RenderRequest request, RenderResponse response, SWFContext swfContext) {
        return this.object_attributes;
    }

    protected Map getFlashVars(RenderRequest request, RenderResponse response, SWFContext swfContext) {
        return this.flash_vars;
    }

    protected void setContextVars(RenderRequest request, RenderResponse response, Context context, SWFContext swfContext) {
        this.setParameterContextVars(request, response, context, swfContext);
        this.readSwfFileInfo(request, response, context, swfContext);
        this.setSizeContextVars(request, response, context, swfContext);
        this.setFinalContextVars(request, response, context, swfContext);
    }

    protected void setFinalContextVars(RenderRequest request, RenderResponse response, Context context, SWFContext swfContext) {
        int swfVersion;
        String namespace = response.getNamespace();
        context.put(NAMESPACE, (Object)namespace);
        context.put(REPLACECONTENT_NODEID, (Object)(namespace + "_flash_replace"));
        String swfObjectsLibUrl = request.getPreferences().getValue(PARAM_SWFOBJECTS_LIB_URL, this.defaultSwfObjectsLibUrl);
        String swfExpressInstallUrl = request.getPreferences().getValue(PARAM_EXPRESS_INSTALL_URL, this.defaultSwfExpressInstallUrl);
        context.put(SWFOBJECTS_LIB_URL, (Object)swfObjectsLibUrl);
        context.put(EXPRESS_INSTALL_URL, (Object)swfExpressInstallUrl);
        int n = swfVersion = swfContext.getHeader() != null ? swfContext.getHeader().getVersion() : -1;
        if (swfVersion > 0) {
            context.put(SWF_VERSION, (Object)(new Integer(swfVersion).toString() + ".0.0"));
        } else {
            context.put(SWF_VERSION, (Object)this.getDefaultSwfVersion());
        }
        context.put("SRC", (Object)swfContext.getSrc());
    }

    protected void setParameterContextVars(RenderRequest request, RenderResponse response, Context context, SWFContext swfContext) {
        context.put(OBJECT_PARAMS, (Object)JSONUtils.makeJSONObject(this.getObjectParameters(request, response, swfContext), true).toString());
        HashMap<String, String> objNodeIdMap = new HashMap<String, String>();
        objNodeIdMap.put(NODEID, response.getNamespace() + "_objnode");
        Map[] attrMaps = new Map[]{this.getObjectAttributes(request, response, swfContext), objNodeIdMap};
        context.put(OBJECT_ATTRIBUTES, (Object)JSONUtils.makeJSONObject(attrMaps, true).toString());
        context.put(FLASHVARS, (Object)JSONUtils.makeJSONObject(this.getFlashVars(request, response, swfContext), true).toString());
    }

    protected void readSwfFileInfo(RenderRequest request, RenderResponse response, Context context, SWFContext swfContext) {
        int swfSrcLen;
        String swfSrc = swfContext.getSrc();
        int n = swfSrcLen = swfSrc != null ? swfSrc.length() : 0;
        if (swfSrcLen > 0) {
            int contextPathLen;
            SWFHeader swfH = new SWFHeader();
            String contextPath = request.getContextPath();
            int n2 = contextPathLen = contextPath != null ? contextPath.length() : 0;
            if (contextPathLen > 0 && swfSrcLen > contextPathLen && swfSrc.startsWith(contextPath)) {
                swfSrc = swfSrc.substring(contextPathLen);
            }
            if (swfH.parseHeader(this.getPortletContext().getResourceAsStream(swfSrc))) {
                swfContext.setHeader(swfH);
            }
        }
    }

    protected void setSizeContextVars(RenderRequest request, RenderResponse response, Context context, SWFContext swfContext) {
        String heightPercent;
        String swfHeight = swfContext.getHeight();
        String swfWidth = swfContext.getWidth();
        String swfHeightActual = null;
        String swfWidthActual = null;
        SWFHeader header = swfContext.getHeader();
        if (header != null) {
            if (header.getHeight() > 0) {
                swfHeightActual = new Integer(header.getHeight()).toString();
            }
            if (header.getWidth() > 0) {
                swfWidthActual = new Integer(header.getWidth()).toString();
            }
        }
        boolean isMaximized = swfContext.isMaximized();
        if (swfHeight == null) {
            swfHeight = swfHeightActual != null ? swfHeightActual : (isMaximized ? "800" : "250");
            swfContext.setHeight(swfHeight);
        }
        if (swfWidth == null) {
            swfWidth = "100%";
            swfContext.setWidth(swfWidth);
        }
        context.put("HEIGHT", (Object)swfHeight);
        context.put("WIDTH", (Object)swfWidth);
        HashMap<String, String> extraSizeVars = new HashMap<String, String>();
        if (swfHeightActual != null) {
            extraSizeVars.put(HEIGHT_ACTUAL, swfHeightActual);
        }
        if (swfWidthActual != null) {
            extraSizeVars.put(WIDTH_ACTUAL, swfWidthActual);
        }
        if ((heightPercent = swfContext.getHeightPercentage()) != null) {
            extraSizeVars.put(HEIGHT_PERCENT, heightPercent);
        }
        context.put(EXTRA_SIZE_INFO, (Object)JSONUtils.makeJSONObject(extraSizeVars, true).toString());
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        Context context = super.getContext(request);
        PortletPreferences prefs = request.getPreferences();
        String swfSrc = null;
        String swfHeight = null;
        String swfWidth = null;
        boolean isMaximized = false;
        if (request.getWindowState().toString().equals(WindowState.MAXIMIZED.toString())) {
            isMaximized = true;
            swfHeight = prefs.getValue(MAX_HEIGHT_PREF, null);
            swfWidth = prefs.getValue(MAX_WIDTH_PREF, null);
            swfSrc = prefs.getValue(MAX_SRC_PREF, null);
        }
        if (swfHeight == null || swfHeight.length() == 0) {
            swfHeight = prefs.getValue("HEIGHT", null);
        }
        if (swfWidth == null || swfWidth.length() == 0) {
            swfWidth = prefs.getValue("WIDTH", null);
        }
        if (swfSrc == null || swfSrc.length() == 0) {
            swfSrc = prefs.getValue("SRC", null);
        }
        context.put(WINDOW_STATE, (Object)(!isMaximized ? "normal" : "max"));
        SWFContext swfContext = new SWFContext(swfSrc, swfHeight, swfWidth, isMaximized);
        this.setContextVars(request, response, context, swfContext);
        if (this.viewPage != null) {
            super.doView(request, response);
        } else {
            this.processClasspathTemplate(PARAM_VIEW_PAGE_DEFAULT, context, response);
        }
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (this.editPage != null) {
            response.setContentType("text/html");
            this.doPreferencesEdit(request, response);
        } else {
            this.setupPreferencesEdit(request, response);
            this.processClasspathTemplate(PARAM_EDIT_PAGE_DEFAULT, this.getContext(request), response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processClasspathTemplate(String classpathTemplate, Context context, RenderResponse response) throws PortletException {
        response.setContentType("text/html");
        VelocityEngine vEngine = null;
        FlashPortlet flashPortlet = this;
        synchronized (flashPortlet) {
            vEngine = this.engine;
            if (vEngine == null) {
                vEngine = new VelocityEngine();
                this.configureClasspathVelocityEngine(vEngine);
                this.engine = vEngine;
            }
        }
        try {
            Template template = vEngine.getTemplate(classpathTemplate);
            StringWriter writer = new StringWriter();
            template.merge(context, (Writer)writer);
            writer.close();
            response.getPortletOutputStream().write(writer.getBuffer().toString().getBytes());
            response.getPortletOutputStream().flush();
        }
        catch (Exception ex) {
            String errMsg = "Failed to generate content with classpath based VelocityEngine for " + ((Object)((Object)this)).getClass().getName() + " due to " + ex.getClass().getName() + " " + ex.getMessage();
            this.log.error(errMsg);
            throw new PortletException(errMsg);
        }
    }

    protected void configureClasspathVelocityEngine(VelocityEngine vEngine) throws PortletException {
        try {
            Properties props = new Properties();
            props.setProperty("resource.loader", "classpath");
            props.setProperty("classpath.resource.loader.class", ClasspathResourceLoader.class.getName());
            vEngine.init(props);
        }
        catch (Exception ex) {
            String errMsg = "Failed to configure classpath based VelocityEngine for " + ((Object)((Object)this)).getClass().getName() + " due to " + ex.getClass().getName() + " " + ex.getMessage();
            this.log.error(errMsg);
            throw new PortletException(errMsg);
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String source = request.getParameter("SRC");
        String height = request.getParameter("HEIGHT");
        String width = request.getParameter("WIDTH");
        String maxSource = request.getParameter(MAX_SRC_PREF);
        String maxHeight = request.getParameter(MAX_HEIGHT_PREF);
        String maxWidth = request.getParameter(MAX_WIDTH_PREF);
        PortletPreferences prefs = request.getPreferences();
        prefs.setValue("SRC", source);
        prefs.setValue("HEIGHT", height);
        prefs.setValue("WIDTH", width);
        prefs.setValue(MAX_SRC_PREF, maxSource);
        prefs.setValue(MAX_HEIGHT_PREF, maxHeight);
        prefs.setValue(MAX_WIDTH_PREF, maxWidth);
        prefs.store();
        super.processAction(request, response);
    }

    public Map parseSemicolonEqualsDelimitedProps(String propsStr) {
        if (propsStr == null || propsStr.length() == 0) {
            return null;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        StringTokenizer parser = new StringTokenizer(propsStr, ";");
        while (parser.hasMoreTokens()) {
            String token = parser.nextToken();
            int eqPos = token.indexOf(61);
            if (eqPos <= 0) continue;
            String propNm = token.substring(0, eqPos);
            if (eqPos >= token.length() - 1) continue;
            String propVal = token.substring(eqPos + 1);
            props.put(propNm.toLowerCase(), propVal);
        }
        return props;
    }

    protected class SWFContext {
        private String src;
        private SWFHeader header;
        private String height;
        private String height_percentage;
        private String width;
        private boolean is_maximized;

        public SWFContext(String swfSrc, String swfHeight, String swfWidth, boolean isMaximized) {
            this.setSrc(swfSrc);
            this.setHeight(swfHeight);
            this.setWidth(swfWidth);
            this.is_maximized = isMaximized;
        }

        public String getSrc() {
            return this.src;
        }

        public void setSrc(String src) {
            if (src == null || src.length() == 0) {
                src = null;
            }
            this.src = src;
        }

        public SWFHeader getHeader() {
            return this.header;
        }

        public void setHeader(SWFHeader swfHeader) {
            this.header = swfHeader;
        }

        public String getHeight() {
            return this.height;
        }

        public void setHeight(String height) {
            if (height == null || height.length() == 0) {
                height = null;
            } else if ((height = height.trim()).endsWith("%")) {
                if (height.length() > 1) {
                    this.height_percentage = height;
                }
                height = null;
            }
            this.height = height;
        }

        public String getHeightPercentage() {
            return this.height_percentage;
        }

        public String getWidth() {
            return this.width;
        }

        public void setWidth(String width) {
            if (width == null || width.length() == 0) {
                width = null;
            }
            this.width = width;
        }

        public boolean isMaximized() {
            return this.is_maximized;
        }
    }
}

