/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.gems.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public abstract class ValidationHelper {
    public static final SimpleDateFormat EUROPEAN_DATE_FORMAT = new SimpleDateFormat("dd-MM-yyyy");
    public static final SimpleDateFormat EUROPEAN_DATETIME_FORMAT = new SimpleDateFormat("dd-MM-yyyy HH:mm");
    public static final SimpleDateFormat AMERICAN_DATE_FORMAT = new SimpleDateFormat("MM-dd-yyyy");
    public static final SimpleDateFormat AMERICAN_DATETIME_FORMAT = new SimpleDateFormat("MM-dd-yyyy HH:mm");

    public static boolean isAlphaNumeric(String evalString, boolean required) {
        if (StringUtils.isEmpty((String)evalString)) {
            return true != required;
        }
        return evalString.matches("^[\\w\\s]+$");
    }

    public static boolean isAlphaNumeric(String evalString, boolean required, int maxLength) {
        if (ValidationHelper.isTooLong(evalString, maxLength)) {
            return false;
        }
        return ValidationHelper.isAlphaNumeric(evalString, required);
    }

    public static boolean isLooseAlphaNumeric(String evalString, boolean required) {
        if (StringUtils.isEmpty((String)evalString)) {
            return true != required;
        }
        return evalString.matches("^[\\w\\s\\.\\,\\/\\-\\(\\)\\+]+$");
    }

    public static boolean isLooseAlphaNumeric(String evalString, boolean required, int maxLength) {
        if (ValidationHelper.isTooLong(evalString, maxLength)) {
            return false;
        }
        return ValidationHelper.isLooseAlphaNumeric(evalString, required);
    }

    public static boolean isDecimal(String evalString, boolean required) {
        if (StringUtils.isEmpty((String)evalString)) {
            return true != required;
        }
        return evalString.matches("^(\\d+\\.)?\\d+$");
    }

    public static boolean isDecimal(String evalString, boolean required, int maxLength) {
        if (ValidationHelper.isTooLong(evalString, maxLength)) {
            return false;
        }
        return ValidationHelper.isDecimal(evalString, required);
    }

    public static boolean isInteger(String evalString, boolean required) {
        if (StringUtils.isEmpty((String)evalString)) {
            return true != required;
        }
        return evalString.matches("^\\d+$");
    }

    public static boolean isInteger(String evalString, boolean required, int maxLength) {
        if (ValidationHelper.isTooLong(evalString, maxLength)) {
            return false;
        }
        return ValidationHelper.isInteger(evalString, required);
    }

    public static boolean isEmailAddress(String evalString, boolean required) {
        if (StringUtils.isEmpty((String)evalString)) {
            return true != required;
        }
        return evalString.matches("^(?:\\w[\\w-]*\\.)*\\w[\\w-]*@(?:\\w[\\w-]*\\.)+\\w[\\w-]*$");
    }

    public static boolean isEmailAddress(String evalString, boolean required, int maxLength) {
        if (ValidationHelper.isTooLong(evalString, maxLength)) {
            return false;
        }
        return ValidationHelper.isEmailAddress(evalString, required);
    }

    public static boolean isURL(String evalString, boolean required) {
        try {
            if (StringUtils.isEmpty((String)evalString)) {
                return true != required;
            }
            return true;
        }
        catch (Exception e) {
            System.err.println(evalString + " is not a valid URL: " + e);
            return false;
        }
    }

    public static boolean isURL(String evalString, boolean required, int maxLength) {
        if (ValidationHelper.isTooLong(evalString, maxLength)) {
            return false;
        }
        return ValidationHelper.isURL(evalString, required);
    }

    public static boolean isValidIdentifier(String folderName) {
        boolean valid = true;
        char[] chars = folderName.toCharArray();
        for (int ix = 0; ix < chars.length; ++ix) {
            if (Character.isJavaIdentifierPart(chars[ix])) continue;
            valid = false;
            break;
        }
        return valid;
    }

    public static boolean isTooLong(String evalString, int maxLength) {
        if (null != evalString) {
            return evalString.length() > maxLength;
        }
        return false;
    }

    public static boolean isPhoneNumber(String evalString, boolean required, int maxLength) {
        if (ValidationHelper.isTooLong(evalString, maxLength)) {
            return false;
        }
        return ValidationHelper.isPhoneNumber(evalString, required);
    }

    public static boolean isPhoneNumber(String evalString, boolean required) {
        if (StringUtils.isEmpty((String)evalString)) {
            return true != required;
        }
        return evalString.matches("(\\+[0-9]{2})?(\\({0,1}[0-9]{3}\\){0,1} {0,1}[ |-]{0,1} {0,1}){0,1}[0-9]{3,5}[ |-][0-9]{4,6}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDate(String formatted) {
        Date date = null;
        if (null == formatted) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = EUROPEAN_DATE_FORMAT;
            synchronized (simpleDateFormat) {
                date = EUROPEAN_DATE_FORMAT.parse(formatted);
            }
        }
        catch (ParseException e) {
            try {
                SimpleDateFormat simpleDateFormat = AMERICAN_DATE_FORMAT;
                synchronized (simpleDateFormat) {
                    date = AMERICAN_DATE_FORMAT.parse(formatted);
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDatetime(String formatted) {
        Date date = null;
        if (null == formatted) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = EUROPEAN_DATETIME_FORMAT;
            synchronized (simpleDateFormat) {
                date = EUROPEAN_DATETIME_FORMAT.parse(formatted);
            }
        }
        catch (ParseException e) {
            try {
                SimpleDateFormat simpleDateFormat = AMERICAN_DATETIME_FORMAT;
                synchronized (simpleDateFormat) {
                    date = AMERICAN_DATETIME_FORMAT.parse(formatted);
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatEuropeanDate(Date date) {
        if (null == date) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = EUROPEAN_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return EUROPEAN_DATE_FORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatAmericanDate(Date date) {
        if (null == date) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = AMERICAN_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return AMERICAN_DATE_FORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatEuropeanDatetime(Date date) {
        if (null == date) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = EUROPEAN_DATETIME_FORMAT;
        synchronized (simpleDateFormat) {
            return EUROPEAN_DATETIME_FORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatAmericanDatetime(Date date) {
        if (null == date) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = AMERICAN_DATETIME_FORMAT;
        synchronized (simpleDateFormat) {
            return AMERICAN_DATETIME_FORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidDate(String formatted) {
        if (formatted == null || formatted.trim().length() == 0) {
            return true;
        }
        try {
            EUROPEAN_DATE_FORMAT.parse(formatted);
        }
        catch (ParseException e) {
            try {
                SimpleDateFormat simpleDateFormat = AMERICAN_DATE_FORMAT;
                synchronized (simpleDateFormat) {
                    AMERICAN_DATE_FORMAT.parse(formatted);
                }
            }
            catch (ParseException ee) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidDatetime(String formatted) {
        if (formatted == null || formatted.trim().length() == 0) {
            return true;
        }
        try {
            SimpleDateFormat simpleDateFormat = EUROPEAN_DATETIME_FORMAT;
            synchronized (simpleDateFormat) {
                EUROPEAN_DATETIME_FORMAT.parse(formatted);
            }
        }
        catch (ParseException e) {
            try {
                SimpleDateFormat simpleDateFormat = AMERICAN_DATETIME_FORMAT;
                synchronized (simpleDateFormat) {
                    AMERICAN_DATETIME_FORMAT.parse(formatted);
                }
            }
            catch (ParseException ee) {
                return false;
            }
        }
        return true;
    }

    public static boolean isAny(String evalString, boolean required) {
        if (StringUtils.isEmpty((String)evalString)) {
            return true != required;
        }
        return true;
    }

    public static boolean isAny(String evalString, boolean required, int maxLength) {
        if (ValidationHelper.isTooLong(evalString, maxLength)) {
            return false;
        }
        return ValidationHelper.isAny(evalString, required);
    }
}

