/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.gems.address;

import java.io.IOException;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.xml.namespace.QName;

import org.apache.portals.bridges.common.GenericServletPortlet;

/**
 * Publishes address events with Portlet 2.0 eventing 
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: AddressEventPortlet.java 773798 2009-05-12 06:17:34Z taylor $
 */
public class AddressEventPortlet extends GenericServletPortlet
{
    public void processAction(ActionRequest request, ActionResponse response) throws PortletException,IOException 
    {        
        QName qname = new QName("http:applications.portals.apache.org/events" , "AddressEvent");
        String address = request.getParameter("address");
        if (address == null)
        {
            address = "";
        }
        AddressEvent addressEvent = new AddressEvent();
        addressEvent.setAddress(address);
        response.setRenderParameter("address", address);        
        response.setEvent(qname, addressEvent);
    }
}