/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.gems.dojo;

import java.io.IOException;

import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import org.apache.portals.bridges.velocity.GenericVelocityPortlet;
import org.apache.portals.gems.dojo.DojoPortletHelper;

/**
 * Abstract DOJO portlet for inserting in cross context dojo widget includes
 * 
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: $
 */
public abstract class AbstractDojoVelocityPortlet extends GenericVelocityPortlet
{
    
    protected static final String DOJO_JS_URL_INIT_PARAM = "dojo.js.url";
    protected static final String DOJO_REQUIRES_CORE_INIT_PARAM = "dojo.requires.core";
    protected static final String DOJO_REQUIRES_MODULES_INIT_PARAM = "dojo.requires.modules";
    
    protected String dojoJsUrl;
    protected String dojoRequiresCoreList;
    protected String dojoRequiresAddOnList;
    
    protected String headerPage;
    
    /*
     * Portlet constructor.
     */
    public AbstractDojoVelocityPortlet() 
    {
        super();
    }

    public void init(PortletConfig config) throws PortletException
    {
        super.init(config);
        this.dojoJsUrl = getInitParameter(DOJO_JS_URL_INIT_PARAM);
        this.dojoRequiresCoreList = getInitParameter( DOJO_REQUIRES_CORE_INIT_PARAM );
        this.dojoRequiresAddOnList = getInitParameter( DOJO_REQUIRES_MODULES_INIT_PARAM );
        this.headerPage = getInitParameter("HeaderPage");
    }
    
    @Override
    protected void doHeaders(RenderRequest request, RenderResponse response)
    {
        DojoPortletHelper.enableDojo(response, this.dojoJsUrl);
        
        if (this.headerPage != null)
        {
            try
            {
                this.getPortletContext().getRequestDispatcher(this.headerPage).include(request, response);
            }
            catch (PortletException e)
            {
                throw new RuntimeException("Failed to include header page.", e);
            }
            catch (IOException e)
            {
                throw new RuntimeException("Failed to include header page.", e);
            }
        }

        if (this.dojoRequiresCoreList != null)
        {
            DojoPortletHelper.contributeDojoRequires(response, this.dojoRequiresCoreList);
        }
        
        if (this.dojoRequiresAddOnList != null)
        {
            DojoPortletHelper.contributeDojoRequires(response, this.dojoRequiresAddOnList);
        }
    }
    
}
