/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceBundleHelper {
    private String bundleName;
    private ResourceBundle resourceBundle;
    private static final Object[] EMPTY_OBJ_ARRAY = new Object[0];
    private static final String EMPTY_STRING = "";

    public ResourceBundleHelper(String bundleName) {
        this.bundleName = bundleName;
        this.resourceBundle = ResourceBundle.getBundle(bundleName);
    }

    public String getMessage(String key) {
        return this.getMessage(key, EMPTY_OBJ_ARRAY);
    }

    public String getMessage(String key, Object obj) {
        return this.getMessage(key, new Object[]{obj});
    }

    public String getMessage(String key, Object[] objArray) {
        String message;
        for (int i = 0; i < objArray.length; ++i) {
            if (objArray[i] != null) continue;
            objArray[i] = EMPTY_STRING;
        }
        String formatStr = null;
        try {
            formatStr = this.resourceBundle.getString(key);
        }
        catch (MissingResourceException missingResExc) {
            // empty catch block
        }
        if (formatStr == null) {
            StringBuffer strBuffer = new StringBuffer("Message entry with key ");
            strBuffer.append(key);
            strBuffer.append(" is missing from resource bundle ");
            strBuffer.append(this.bundleName);
            strBuffer.append("\n");
            strBuffer.append(this.bundleName);
            strBuffer.append(":: ");
            strBuffer.append(key);
            for (int i = 0; i < objArray.length; ++i) {
                strBuffer.append(" ");
                strBuffer.append(objArray[i].toString());
            }
            message = strBuffer.toString();
        } else {
            MessageFormat msgformat = new MessageFormat(formatStr);
            message = msgformat.format(objArray);
        }
        return message;
    }
}

