/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import org.tp23.antinstaller.renderer.MessageRenderer;
import org.tp23.antinstaller.renderer.swing.AIPasswordField;
import org.tp23.antinstaller.renderer.swing.SizeConstants;
import org.tp23.antinstaller.renderer.swing.ValidatedTextInputRenderer;
import org.tp23.gui.GBCF;

public class PasswordTextInputRenderer
extends ValidatedTextInputRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");

    public PasswordTextInputRenderer() {
        this.jTextField = new AIPasswordField();
        this.origFore = this.jTextField.getForeground();
    }

    public void renderError() {
        MessageRenderer mr = this.ctx.getMessageRenderer();
        mr.printMessage(this.getErrorMessage());
        this.jTextField.requestFocus();
        this.jTextField.setForeground(Color.red);
        this.jTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() != '\t') {
                    PasswordTextInputRenderer.this.inputField.setEditted(true);
                }
            }
        });
    }

    public int addSelf(JPanel content, GBCF cf, int row, boolean overflow) {
        content.add((Component)this.fieldLabel, cf.getCell(row, 0));
        content.add((Component)this.jTextField, cf.getCell(row, 1));
        if (overflow) {
            ((AIPasswordField)this.jTextField).setOverflow(SizeConstants.OVERFLOW_FIELD_SIZE);
        }
        return ++row;
    }

    protected String getErrorMessage() {
        return res.getString("notCorrectPasswordFormat") + "\n\n e.g. " + this.inputField.getDefaultValue();
    }
}

