/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.jgoodies.plaf.plastic.common;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Robot;
import javax.swing.ImageIcon;
import javax.swing.JWindow;
import javax.swing.border.Border;

public final class ShadowPopupBorder
implements Border {
    private static final Insets SHADOW_INSETS = new Insets(0, 0, 5, 5);
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static ShadowPopupBorder instance = new ShadowPopupBorder();
    private static Image hShadowBg;
    private static Image vShadowBg;
    private static Image shadow;
    private static boolean active;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.tp23.jgoodies.plaf.plastic.common.ShadowPopupBorder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        shadow = new ImageIcon(clazz.getResource("shadow.png")).getImage();
        active = true;
    }

    public static ShadowPopupBorder getInstance() {
        return instance;
    }

    private static boolean isActive() {
        return active;
    }

    public static void setActive(boolean b) {
        active = b;
    }

    public static void clearSnapshot() {
        vShadowBg = null;
        hShadowBg = null;
    }

    public static void makeSnapshot(JWindow window) {
        try {
            Robot robot = new Robot();
            int x = window.getX();
            int y = window.getY();
            Dimension dim = window.getPreferredSize();
            hShadowBg = robot.createScreenCapture(new Rectangle(x, y + dim.height - 5, dim.width, 5));
            vShadowBg = robot.createScreenCapture(new Rectangle(x + dim.width - 5, y, 5, dim.height - 5));
        }
        catch (AWTException e) {
            ShadowPopupBorder.clearSnapshot();
        }
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (!ShadowPopupBorder.isActive()) {
            return;
        }
        if (hShadowBg != null) {
            g.drawImage(hShadowBg, x, y + height - 5, c);
        }
        if (vShadowBg != null) {
            g.drawImage(vShadowBg, x + width - 5, y, c);
        }
        g.drawImage(shadow, x + 5, y + height - 5, x + 10, y + height, 0, 6, 5, 11, null, c);
        g.drawImage(shadow, x + 10, y + height - 5, x + width - 5, y + height, 5, 6, 6, 11, null, c);
        g.drawImage(shadow, x + width - 5, y + 5, x + width, y + 10, 6, 0, 11, 5, null, c);
        g.drawImage(shadow, x + width - 5, y + 10, x + width, y + height - 5, 6, 5, 11, 6, null, c);
        g.drawImage(shadow, x + width - 5, y + height - 5, x + width, y + height, 6, 6, 11, 11, null, c);
    }

    public Insets getBorderInsets(Component c) {
        return ShadowPopupBorder.isActive() ? SHADOW_INSETS : EMPTY_INSETS;
    }
}

