/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.pluto.container.impl;


import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.PortletRequest;

import org.apache.pluto.container.PortletEventResponseContext;
import org.apache.pluto.container.PortletRequestContext;

/**
 * <code>javax.portlet.EventRequest</code> implementation.
 *
 */
public class EventRequestImpl extends PortletRequestImpl implements EventRequest
{
	private final Event event; 
	
    public EventRequestImpl(PortletRequestContext requestContext, PortletEventResponseContext responseContext, Event event)
    {
        super(requestContext, responseContext, PortletRequest.EVENT_PHASE);
        this.event = event;
    }
    
    public Event getEvent()
    {
        return event;
    }

    public String getMethod()
    {
        return getServletRequest().getMethod();
    }
}
